/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.rest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Parameter;
import org.restlet.data.Preference;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.resource.ClientResource;
import org.restlet.util.Series;

public class Resources {
    private final Client client;
    private ObjectMapper mapper = new ObjectMapper();
    private final Reference ref;
    private String user;
    private String password;

    public Resources(String url, Client client) {
        this.client = client;
        this.ref = new Reference(new Reference(url), "/");
    }

    private Context createContext() {
        Context context = new Context();
        context.setClientDispatcher((Restlet)this.client);
        return context;
    }

    public void setAuth(String user, String password) {
        this.user = user;
        this.password = password;
    }

    public DiscoveryClientResource getDiscoveryResource() throws IOException {
        DiscoveryClientResource discovery = this.withAuth(new DiscoveryClientResource(this.createContext(), this.ref));
        discovery.readInformation();
        return discovery;
    }

    <T extends ClientResource> T withAuth(T resource) {
        if (this.hasAuth()) {
            resource.setChallengeResponse(ChallengeScheme.HTTP_BASIC, this.user, this.password);
        }
        return resource;
    }

    private boolean hasAuth() {
        return this.user != null && this.password != null;
    }

    public ClientResource getCypherResource(String cypherPath) {
        return this.withAuth(new CypherClientResource(new Context(), cypherPath, this.mapper));
    }

    public TransactionClientResource getTransactionResource(String transactionPath) {
        return this.withAuth(new TransactionClientResource(new Context(), transactionPath));
    }

    public TransactionClientResource getTransactionResource(Reference transactionPath) {
        return this.withAuth(new TransactionClientResource(new Context(), transactionPath));
    }

    public JsonNode readJsonFrom(String uri) {
        try {
            ClientResource resource = this.withAuth(new ClientResource(this.createContext(), uri));
            resource.getClientInfo().setAcceptedMediaTypes(Resources.streamingJson());
            return this.mapper.readTree(resource.get().getReader());
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error reading data from URI " + uri);
        }
    }

    private String textField(JsonNode node, String field) {
        JsonNode fieldNode = node.get(field);
        if (fieldNode == null) {
            return null;
        }
        return fieldNode.getTextValue();
    }

    public TransactionClientResource subResource(TransactionClientResource res, String segment) {
        return this.withAuth(res.subResource(segment));
    }

    private static List<Preference<MediaType>> streamingJson() {
        MediaType mediaType = Resources.streamingJsonType();
        return Collections.singletonList(new Preference((Metadata)mediaType));
    }

    private static MediaType streamingJsonType() {
        Series parameters = new Series(Parameter.class);
        parameters.add("stream", "true");
        return new MediaType(MediaType.APPLICATION_JSON.getName(), parameters);
    }

    public static class TransactionClientResource
    extends ClientResource {
        public TransactionClientResource(Context context, String path) {
            super(context, path);
            this.getClientInfo().setAcceptedMediaTypes(Resources.streamingJson());
        }

        public TransactionClientResource(Context context, Reference path) {
            super(context, path);
            this.getClientInfo().setAcceptedMediaTypes(Resources.streamingJson());
        }

        public TransactionClientResource subResource(String segment) {
            return new TransactionClientResource(this.getContext(), this.getReference().clone().addSegment(segment));
        }

        public void doError(Status errorStatus) {
            String errors = this.getResponse().getEntityAsText();
            if (errors == null || !errors.isEmpty()) {
                super.doError(new Status(errorStatus.getCode(), "Error executing statement", errors, errorStatus.getUri()));
            }
            super.doError(errorStatus);
        }

        private Collection<Object> findErrors(JsonParser parser) throws IOException {
            parser.nextToken();
            if ("results".equals(parser.getCurrentName())) {
                parser.skipChildren();
                parser.nextToken();
            }
            List errors = Collections.emptyList();
            if ("errors".equals(parser.getCurrentName()) && JsonToken.START_ARRAY == parser.nextToken()) {
                errors = (List)parser.readValueAs((TypeReference)new TypeReference<Object>(){});
            }
            return errors;
        }
    }

    private static class CypherClientResource
    extends ClientResource {
        private final ObjectMapper mapper;

        public CypherClientResource(Context context, String cypherPath, ObjectMapper mapper) {
            super(context, cypherPath);
            this.mapper = mapper;
            this.getClientInfo().setAcceptedMediaTypes(Resources.streamingJson());
        }

        public void doError(Status errorStatus) {
            try {
                JsonNode node = this.mapper.readTree(this.getResponse().getEntity().getReader());
                JsonNode message = node.get("message");
                if (message != null) {
                    super.doError(new Status(errorStatus.getCode(), message.toString(), message.toString(), errorStatus.getUri()));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            super.doError(errorStatus);
        }
    }

    public class DiscoveryClientResource
    extends ClientResource {
        private String version;
        private String cypherPath;
        private String transactionPath;
        private String dataUri;
        private String labelPath;
        private String relationshipTypesPath;
        private String propertyKeysPath;

        public DiscoveryClientResource(Context context, Reference ref) {
            super(context, ref);
            this.getClientInfo().setAcceptedMediaTypes(Resources.streamingJson());
        }

        public String getVersion() {
            return this.version;
        }

        public void readInformation() throws IOException {
            JsonNode discoveryInfo = Resources.this.mapper.readTree(this.get().getReader());
            this.dataUri = Resources.this.textField(discoveryInfo, "data");
            JsonNode serverData = Resources.this.readJsonFrom(this.dataUri);
            this.version = Resources.this.textField(serverData, "neo4j_version");
            this.cypherPath = this.obtainCypherPath(serverData);
            this.labelPath = this.dataUri + "/labels";
            this.relationshipTypesPath = serverData.get("relationship_types").asText();
            this.propertyKeysPath = this.dataUri + "/propertykeys";
            this.transactionPath = Resources.this.textField(serverData, "transaction");
            if (this.transactionPath == null && (this.version.startsWith("2") || this.version.equals("1.9.M02-1083-g0593b83"))) {
                this.transactionPath = this.dataUri + "/transaction";
            }
        }

        private String obtainCypherPath(JsonNode serverData) {
            JsonNode plugin;
            JsonNode extensions;
            String cypherPath = Resources.this.textField(serverData, "cypher");
            if (cypherPath == null && (extensions = serverData.get("extensions")) != null && (plugin = extensions.get("CypherPlugin")) != null) {
                cypherPath = Resources.this.textField(plugin, "execute_query");
            }
            return cypherPath;
        }

        public String getCypherPath() {
            return this.cypherPath;
        }

        public Collection<String> getLabels() {
            return this.readListFrom(this.labelPath);
        }

        public Collection<String> getRelationshipTypes() {
            return this.readListFrom(this.relationshipTypesPath);
        }

        public Collection<String> getPropertyKeys() {
            return this.readListFrom(this.propertyKeysPath);
        }

        private Collection<String> readListFrom(String uri) {
            Iterator it = Resources.this.readJsonFrom(uri).getElements();
            ArrayList<String> result = new ArrayList<String>();
            while (it.hasNext()) {
                result.add(((JsonNode)it.next()).asText());
            }
            return result;
        }

        public String getTransactionPath() {
            return this.transactionPath;
        }
    }
}

