/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.io.Closeable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.neo4j.jdbc.util.Closer;

public class ExecutionResult
implements Iterable<Object[]>,
Closeable {
    public static final ExecutionResult EMPTY_RESULT = new ExecutionResult(Collections.emptyList(), Collections.emptyList().iterator());
    private List<String> columns;
    private Iterator<Object[]> result;
    private final boolean isLazy;

    public ExecutionResult(List<String> columns, Iterator<Object[]> result) {
        this.columns = columns;
        this.result = result;
        this.isLazy = !(result instanceof Collection);
    }

    public List<String> columns() {
        return this.columns;
    }

    public boolean isLazy() {
        return this.isLazy;
    }

    @Override
    public Iterator<Object[]> iterator() {
        return this.result;
    }

    public String toString() {
        String result = "Columns:" + this.columns;
        result = result + "\n" + this.result;
        return result;
    }

    public Iterator<Object[]> getResult() {
        return this.result;
    }

    @Override
    public void close() {
        Closer.close(this.result);
    }
}

