/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.rest;

import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.neo4j.jdbc.rest.JsonUtils;

public class Statement {
    final String query;
    final Map<String, Object> params;

    Statement(String query, Map<String, Object> params) {
        this.query = query;
        this.params = params;
    }

    public ObjectNode toJson(ObjectMapper mapper) {
        ObjectNode queryNode = mapper.createObjectNode();
        queryNode.put("statement", this.escapeQuery(this.query));
        if (this.params != null && !this.params.isEmpty()) {
            queryNode.put("parameters", (JsonNode)JsonUtils.serialize(this.params, mapper));
        }
        return queryNode;
    }

    public String toString() {
        return "query: " + this.query + "\nparams:" + this.params;
    }

    private String escapeQuery(String query) {
        return query.replace('\"', '\'').replace('\n', ' ');
    }

    public static ArrayNode toJson(ObjectMapper mapper, Statement ... statements) {
        ArrayNode result = mapper.createArrayNode();
        if (statements == null || statements.length == 0) {
            return result;
        }
        for (Statement statement : statements) {
            result.add((JsonNode)statement.toJson(mapper));
        }
        return result;
    }
}

