/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.embedded;

import java.util.Properties;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.jdbc.Databases;
import org.neo4j.jdbc.QueryExecutor;
import org.neo4j.jdbc.embedded.EmbeddedQueryExecutor;
import org.neo4j.test.ImpermanentGraphDatabase;

public class EmbeddedDatabases
implements Databases {
    private static final Pattern urlMatcher = Pattern.compile(":([^:]*):(.+)");
    private final WeakHashMap<String, GraphDatabaseService> databases = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphDatabaseService createDatabase(String connectionUrl, Properties properties) {
        Matcher matcher = urlMatcher.matcher(connectionUrl);
        if (!matcher.find()) {
            return this.defaultImpermanentDb();
        }
        try {
            Type type = Type.valueOf(matcher.group(1));
            String name = matcher.group(2);
            GraphDatabaseService gds = this.databases.get(name);
            if (gds != null) {
                return gds;
            }
            Pattern pattern = urlMatcher;
            synchronized (pattern) {
                gds = this.databases.get(name);
                if (gds != null) {
                    return gds;
                }
                gds = type.create(name, properties);
                this.databases.put(name, gds);
            }
            return gds;
        }
        catch (IllegalArgumentException e) {
            return this.defaultImpermanentDb();
        }
    }

    private GraphDatabaseService defaultImpermanentDb() {
        return new ImpermanentGraphDatabase();
    }

    @Override
    public QueryExecutor createExecutor(String connectionUrl, Properties properties) {
        GraphDatabaseService gds = this.createDatabase(connectionUrl, properties);
        return new EmbeddedQueryExecutor(gds);
    }

    static enum Type {
        mem{

            @Override
            public GraphDatabaseService create(String name, Properties properties) {
                return new ImpermanentGraphDatabase();
            }
        }
        ,
        instance{

            @Override
            public GraphDatabaseService create(String name, Properties properties) {
                return (GraphDatabaseService)properties.remove(name);
            }
        }
        ,
        file{

            @Override
            public GraphDatabaseService create(String name, Properties properties) {
                if (this.isReadOnly(properties)) {
                    return new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(name).setConfig(GraphDatabaseSettings.read_only, "true").newGraphDatabase();
                }
                return new GraphDatabaseFactory().newEmbeddedDatabase(name);
            }
        };


        public abstract GraphDatabaseService create(String var1, Properties var2);

        protected boolean isReadOnly(Properties properties) {
            return properties != null && properties.getProperty("readonly", "false").equalsIgnoreCase("true");
        }
    }
}

