/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.neo4j.jdbc.ListResultSet;
import org.neo4j.jdbc.Neo4jColumnMetaData;
import org.neo4j.jdbc.Neo4jConnection;

public class ResultSetBuilder {
    private List<Neo4jColumnMetaData> columns = new ArrayList<Neo4jColumnMetaData>();
    private List<List<Object>> data = new ArrayList<List<Object>>();
    private List<Object> currentRow = new ArrayList<Object>();

    public ResultSetBuilder column(String name, int type) {
        String typeName = null;
        if (type == 12) {
            typeName = String.class.getName();
        } else if (type == 4) {
            typeName = Integer.class.getName();
        }
        this.columns.add(new Neo4jColumnMetaData(name, typeName, type));
        return this;
    }

    public ResultSetBuilder column(String name) {
        return this.column(name, 12);
    }

    public ResultSetBuilder rowData(Collection<Object> values) {
        this.currentRow = new ArrayList<Object>();
        this.currentRow.addAll(values);
        for (int i = this.currentRow.size(); i < this.columns.size(); ++i) {
            this.currentRow.add(null);
        }
        this.data.add(this.currentRow);
        return this;
    }

    public ResultSetBuilder row(Object ... values) {
        return this.rowData(Arrays.asList(values));
    }

    public ResultSetBuilder cell(String name, Object value) {
        int i = this.getColumnIndex(name);
        if (i == -1) {
            throw new IllegalArgumentException("No such column declared:" + name);
        }
        this.currentRow.set(i, value);
        return this;
    }

    public ResultSet newResultSet(Connection connection) throws SQLException {
        return new ListResultSet(this.columns, this.data, connection.unwrap(Neo4jConnection.class));
    }

    private int getColumnIndex(String name) {
        for (int i = 0; i < this.columns.size(); ++i) {
            Neo4jColumnMetaData columnMetaData = this.columns.get(i);
            if (!columnMetaData.getName().equals(name)) continue;
            return i;
        }
        return -1;
    }
}

