/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.jdbc.AbstractPreparedStatement;
import org.neo4j.jdbc.Neo4jConnection;

public class Neo4jPreparedStatement
extends AbstractPreparedStatement {
    private String query;
    private Map<String, Object> parameters = new HashMap<String, Object>();

    public Neo4jPreparedStatement(Neo4jConnection connection, String query) {
        super(connection);
        this.query = query;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.resultSet = this.connection.executeQuery(this.query, this.parameters);
        return this.resultSet;
    }

    @Override
    public boolean execute() throws SQLException {
        this.resultSet = this.connection.executeQuery(this.query, this.parameters);
        return true;
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.resultSet = this.connection.executeQuery(this.query, this.parameters);
        while (this.resultSet.next()) {
        }
        return 0;
    }

    private void add(int parameterIndex, Object value) {
        this.parameters.put(Integer.toString(parameterIndex), value);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.resultSet == null) {
            this.execute();
        }
        return this.resultSet.getMetaData();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.add(parameterIndex, null);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean value) throws SQLException {
        this.add(parameterIndex, value);
    }

    @Override
    public void setByte(int parameterIndex, byte value) throws SQLException {
        this.add(parameterIndex, value);
    }

    @Override
    public void setShort(int parameterIndex, short value) throws SQLException {
        this.add(parameterIndex, value);
    }

    @Override
    public void setInt(int parameterIndex, int value) throws SQLException {
        this.add(parameterIndex, value);
    }

    @Override
    public void setLong(int parameterIndex, long value) throws SQLException {
        this.add(parameterIndex, value);
    }

    @Override
    public void setFloat(int parameterIndex, float value) throws SQLException {
        this.add(parameterIndex, Float.valueOf(value));
    }

    @Override
    public void setDouble(int parameterIndex, double value) throws SQLException {
        this.add(parameterIndex, value);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal value) throws SQLException {
        this.add(parameterIndex, value);
    }

    @Override
    public void setString(int parameterIndex, String value) throws SQLException {
        this.add(parameterIndex, value);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] value) throws SQLException {
        this.add(parameterIndex, value);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.parameters.clear();
    }

    @Override
    public void setObject(int parameterIndex, Object value, int targetSqlType) throws SQLException {
        this.add(parameterIndex, value);
    }

    @Override
    public void setObject(int parameterIndex, Object value) throws SQLException {
        this.add(parameterIndex, value);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.add(parameterIndex, null);
    }

    @Override
    public void setObject(int parameterIndex, Object value, int targetSqlType, int scaleOrLength) throws SQLException {
        this.add(parameterIndex, value);
    }
}

