/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neo4j.jdbc.Connections;
import org.neo4j.jdbc.Databases;
import org.neo4j.jdbc.DriverQueries;
import org.neo4j.jdbc.Neo4jConnection;
import org.neo4j.jdbc.QueryExecutor;

public class Driver
implements java.sql.Driver {
    private static final Log log = LogFactory.getLog(Driver.class);
    public static final String CON_PREFIX = "jdbc:neo4j:";
    static final String LEGACY = "legacy";
    static final String URL_PREFIX = "jdbc:neo4j";
    static final String PASSWORD = "password";
    static final String USER = "user";
    DriverQueries queries;
    private final Databases databases = this.createDatabases();

    public Driver() {
        this.queries = new DriverQueries();
    }

    @Override
    public Neo4jConnection connect(String url, Properties properties) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        this.parseUrlProperties(url, properties);
        return Connections.create(this, url, properties);
    }

    @Override
    public boolean acceptsURL(String s) throws SQLException {
        return s.startsWith(CON_PREFIX);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String s, Properties props) throws SQLException {
        return new DriverPropertyInfo[]{this.infoFor(props, "debug"), this.infoFor(props, USER), this.infoFor(props, PASSWORD)};
    }

    private DriverPropertyInfo infoFor(Properties properties, String name) {
        return new DriverPropertyInfo(name, properties.getProperty(name));
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    public DriverQueries getQueries() {
        return this.queries;
    }

    void parseUrlProperties(String s, Properties properties) {
        if (s.contains("?")) {
            String[] props;
            String urlProps = s.substring(s.indexOf(63) + 1);
            for (String prop : props = urlProps.split(",")) {
                int idx = prop.indexOf(61);
                if (idx != -1) {
                    String key = prop.substring(0, idx);
                    String value = prop.substring(idx + 1);
                    properties.put(key, value);
                    continue;
                }
                properties.put(prop, "true");
            }
        }
    }

    private Databases createDatabases() {
        try {
            return (Databases)Class.forName("org.neo4j.jdbc.embedded.EmbeddedDatabases").newInstance();
        }
        catch (Throwable e) {
            log.warn((Object)("Embedded Neo4j support not enabled " + e.getMessage()));
            return null;
        }
    }

    public QueryExecutor createExecutor(String connectionUrl, Properties properties) throws SQLException {
        if (this.databases == null) {
            throw new SQLFeatureNotSupportedException("Embedded Neo4j not available please add neo4j-kernel, -index and -cypher to the classpath");
        }
        return this.databases.createExecutor(connectionUrl, properties);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

