/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.logging.Logger;
import org.neo4j.jdbc.Driver;

public class CallProxy
implements InvocationHandler {
    private Object next;

    public static <T> T proxy(Class<T> clazz, T next) {
        return clazz.cast(Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new CallProxy(next)));
    }

    private static void log(String str) {
        Logger.getLogger(Driver.class.getName()).info(str);
    }

    public CallProxy(Object next) {
        this.next = next;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (!method.getDeclaringClass().equals(Object.class)) {
            String call = method.getDeclaringClass().getSimpleName() + "." + method.getName() + "(";
            if (args != null) {
                String comma = "";
                for (Object arg : args) {
                    call = call + comma + (arg == null ? "null" : arg.toString());
                    comma = ", ";
                }
            }
            call = call + ")";
            CallProxy.log(call);
            try {
                Object result = method.invoke(this.next, args);
                if (!method.getReturnType().equals(Void.TYPE)) {
                    CallProxy.log("->" + result + "\n");
                }
                return result;
            }
            catch (InvocationTargetException e) {
                StringWriter str = new StringWriter();
                PrintWriter print = new PrintWriter((Writer)str, true);
                e.printStackTrace(print);
                throw e.getTargetException();
            }
        }
        return method.invoke(this.next, args);
    }
}

