/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.rest;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.codehaus.jackson.JsonNode;

public class ResultParser {
    private final JsonNode node;
    private List<String> columns;
    private int cols;
    private final Object[] rowData;

    public ResultParser(JsonNode node) {
        this.node = node;
        this.columns = this.parseColumns();
        this.cols = this.columns.size();
        this.rowData = new Object[this.cols];
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public List<String> parseColumns() {
        ArrayList<String> columns = new ArrayList<String>(20);
        for (JsonNode column : this.node.get("columns")) {
            String textValue = column.getTextValue();
            columns.add(textValue);
        }
        return columns;
    }

    Iterator<Object[]> streamData() {
        final Iterator rows = this.node.get("data").iterator();
        return new Iterator<Object[]>(){

            @Override
            public boolean hasNext() {
                return rows.hasNext();
            }

            @Override
            public Object[] next() {
                return ResultParser.this.parseRow((JsonNode)rows.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private Object[] parseRow(JsonNode row) {
        int i = 0;
        for (JsonNode cell : row) {
            this.rowData[i++] = this.toObject(cell);
        }
        while (i < this.cols) {
            this.rowData[i] = null;
            ++i;
        }
        return this.rowData;
    }

    private Object toObject(JsonNode cell) {
        if (cell.isObject()) {
            if (cell.has("length") && cell.has("nodes") && cell.has("relationships")) {
                return this.toPath(cell);
            }
            Map<String, Object> result = this.toPropertyContainer(cell);
            return this.addRelationshipInfo(cell, result);
        }
        if (cell.isArray()) {
            ArrayList<Object> result = new ArrayList<Object>(cell.size());
            for (JsonNode node : cell) {
                result.add(this.toObject(node));
            }
            return result;
        }
        if (cell.isTextual()) {
            return cell.getTextValue();
        }
        if (cell.isBoolean()) {
            return cell.getBooleanValue();
        }
        if (cell.isNumber()) {
            return cell.getNumberValue();
        }
        return cell.getTextValue();
    }

    private Object addRelationshipInfo(JsonNode cell, Map<String, Object> result) {
        if (cell.has("start")) {
            result.put("_start", this.idOf(cell.get("start")));
        }
        if (cell.has("end")) {
            result.put("_end", this.idOf(cell.get("end")));
        }
        if (cell.has("type")) {
            result.put("_type", cell.get("type").getTextValue());
        }
        return result;
    }

    private Map<String, Object> toPropertyContainer(JsonNode cell) {
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        String idField = cell.has("type") ? "_rel_id" : "_node_id";
        result.put(idField, this.idOf(cell.get("self")));
        JsonNode data = cell.get("data");
        if (data != null && data.isObject() && data.size() > 0) {
            Iterator fieldNames = data.getFieldNames();
            while (fieldNames.hasNext()) {
                String fieldName = (String)fieldNames.next();
                result.put(fieldName, this.toObject(data.get(fieldName)));
            }
        }
        return result;
    }

    private ArrayList<Object> toPath(JsonNode cell) {
        ArrayList<Object> path = new ArrayList<Object>(cell.get("length").getIntValue() + 1);
        Iterator nodes = cell.get("nodes").iterator();
        Iterator relationships = cell.get("relationships").iterator();
        while (nodes.hasNext()) {
            path.add(this.map("_node_id", this.idOf((JsonNode)nodes.next())));
            if (!relationships.hasNext()) continue;
            path.add(this.map("_rel_id", this.idOf((JsonNode)relationships.next())));
        }
        return path;
    }

    private Map<String, Object> map(String key, Object value) {
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        result.put(key, value);
        return result;
    }

    private Long idOf(JsonNode node) {
        if (node == null) {
            return null;
        }
        String uri = node.getTextValue();
        if (uri == null) {
            return null;
        }
        int idx = uri.lastIndexOf("/");
        return idx == -1 ? null : Long.valueOf(uri.substring(idx + 1));
    }
}

