/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.neo4j.jdbc.AbstractResultSet;
import org.neo4j.jdbc.Neo4jColumnMetaData;
import org.neo4j.jdbc.Neo4jConnection;
import org.neo4j.jdbc.util.ClosableIterator;

public class IteratorResultSet
extends AbstractResultSet {
    private Iterator<Object[]> data;
    private Object[] currentRow;
    private int row = -1;

    public IteratorResultSet(List<Neo4jColumnMetaData> columns, Iterator<Object[]> data, Neo4jConnection conn) {
        super(columns, conn);
        this.data = data;
        data.hasNext();
    }

    public IteratorResultSet(Neo4jConnection conn, List<String> columns, Iterator<Object[]> data) {
        super(conn, columns);
        this.data = data;
        data.hasNext();
    }

    @Override
    protected Object[] currentRow() {
        return this.currentRow;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.hasNext()) {
            this.currentRow = this.data.next();
            ++this.row;
            return true;
        }
        return false;
    }

    @Override
    public void close() throws SQLException {
        if (this.data instanceof AutoCloseable) {
            try {
                ((AutoCloseable)((Object)this.data)).close();
            }
            catch (Exception e) {
                log.warn((Object)"Couldn't close resultset", (Throwable)e);
            }
        } else if (this.data instanceof ClosableIterator) {
            ((ClosableIterator)this.data).close();
        }
        super.close();
    }

    private boolean hasNext() {
        return this.data.hasNext();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.row == -1;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return !this.hasNext();
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.row == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        return !this.hasNext();
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
    }

    @Override
    public void afterLast() throws SQLException {
        throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
    }

    @Override
    public boolean first() throws SQLException {
        throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
    }

    @Override
    public boolean last() throws SQLException {
        throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
    }

    @Override
    public int getRow() throws SQLException {
        return this.row;
    }

    @Override
    public boolean absolute(int i) throws SQLException {
        throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
    }

    @Override
    public boolean relative(int i) throws SQLException {
        throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
    }

    @Override
    public boolean previous() throws SQLException {
        throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
    }

    @Override
    public void setFetchDirection(int i) throws SQLException {
        if (i != 1000) {
            throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchSize(int i) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return super.isClosed();
    }

    @Override
    public String toString() {
        return super.toString() + " current row " + this.row + ": " + Arrays.toString(this.currentRow);
    }
}

