/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.rest;

import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ObjectNode;
import org.neo4j.jdbc.ExecutionResult;
import org.neo4j.jdbc.QueryExecutor;
import org.neo4j.jdbc.Version;
import org.neo4j.jdbc.rest.Resources;
import org.neo4j.jdbc.rest.Statement;
import org.neo4j.jdbc.rest.StreamingParser;
import org.restlet.Response;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.ClientResource;
import org.restlet.resource.ResourceException;
import org.restlet.routing.Filter;

public class TransactionalQueryExecutor
implements QueryExecutor {
    protected static final Log log = LogFactory.getLog(TransactionalQueryExecutor.class);
    private static final Statement[] NO_STATEMENTS = new Statement[0];
    private static final Iterator<ExecutionResult> NO_RESULTS = Collections.emptyList().iterator();
    private final Resources.TransactionClientResource commitResource;
    private final Resources.TransactionClientResource txResource;
    private final ThreadLocal<Resources.TransactionClientResource> transaction = new ThreadLocal();
    private final ObjectMapper mapper = new ObjectMapper();
    private final Version version;
    private final Resources resources;
    private final StreamingParser resultParser;
    private final Resources.DiscoveryClientResource discovery;

    public TransactionalQueryExecutor(Resources resources) throws SQLException {
        try {
            this.resources = resources;
            this.resultParser = new StreamingParser(this.mapper);
            this.discovery = resources.getDiscoveryResource();
            this.version = new Version(this.discovery.getVersion());
            String transactionPath = this.discovery.getTransactionPath();
            this.txResource = resources.getTransactionResource(transactionPath);
            this.commitResource = resources.subResource(this.txResource, "commit");
        }
        catch (IOException e) {
            throw new SQLNonTransientConnectionException(e);
        }
    }

    public Iterator<ExecutionResult> begin(Statement ... statements) throws SQLException {
        Resources.TransactionClientResource resource = this.hasActiveTransaction() ? this.activeTransaction() : this.txResource;
        Response result = this.post(resource, statements);
        if (result.getLocationRef() != null) {
            this.transaction.set(this.resources.getTransactionResource(result.getLocationRef()));
        }
        return this.toResults(result.getEntity(), statements);
    }

    private Resources.TransactionClientResource activeTransaction() {
        return this.transaction.get();
    }

    private boolean hasActiveTransaction() {
        return this.activeTransaction() != null;
    }

    private Response post(Resources.TransactionClientResource resource, Statement[] data) {
        ObjectNode requestData = this.mapper.createObjectNode();
        requestData.put("statements", (JsonNode)Statement.toJson(this.mapper, data));
        resource.post(this.toRepresentation(requestData, resource));
        Response response = resource.getResponse();
        return response;
    }

    private void dump(Representation response) {
        try {
            System.out.println("response.getText() = " + response.getText());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Representation toRepresentation(ObjectNode requestData, ClientResource requestResource) {
        String jsonString = this.toString(requestData);
        Variant variant = new Variant(MediaType.APPLICATION_JSON);
        variant.setCharacterSet(CharacterSet.UTF_8);
        return requestResource.toRepresentation((Object)jsonString, variant);
    }

    public Iterator<ExecutionResult> commit(Statement ... statements) throws SQLException {
        boolean hasActiveTransaction = this.hasActiveTransaction();
        if (!(statements != null && statements.length != 0 || hasActiveTransaction)) {
            return NO_RESULTS;
        }
        Resources.TransactionClientResource resource = hasActiveTransaction ? this.resources.subResource(this.activeTransaction(), "commit") : this.commitResource;
        Representation result = this.post(resource, statements).getEntity();
        this.clearTransaction();
        if (result.isAvailable()) {
            return this.toResults(result, statements);
        }
        return NO_RESULTS;
    }

    private void clearTransaction() {
        this.transaction.set(null);
    }

    private Iterator<ExecutionResult> toResults(Representation result, Statement[] statements) throws SQLException {
        final Reader reader = this.getReader(result);
        AutoCloseable closeable = new AutoCloseable(){

            @Override
            public void close() throws Exception {
                reader.close();
            }
        };
        return this.resultParser.toResults(this.resultParser.obtainParser(reader), closeable, statements);
    }

    private Reader getReader(Representation result) {
        try {
            return result.getReader();
        }
        catch (IOException e) {
            throw new RuntimeException("Error accessing response reader", e);
        }
    }

    private String toString(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public void rollback() throws SQLException {
        if (this.hasActiveTransaction()) {
            Resources.TransactionClientResource resource = this.activeTransaction();
            resource.delete();
            if (resource.getResponse().isEntityAvailable()) {
                this.clearTransaction();
            }
        }
    }

    public Iterator<ExecutionResult> executeQueries(Statement ... statements) throws Exception {
        if (this.hasActiveTransaction()) {
            Representation result = this.post(this.activeTransaction(), statements).getEntity();
            return this.toResults(result, statements);
        }
        return this.commit(statements);
    }

    @Override
    public ExecutionResult executeQuery(String query, Map<String, Object> parameters, boolean autoCommit) throws Exception {
        try {
            Iterator<ExecutionResult> res;
            Statement statement = new Statement(query, parameters);
            Iterator<ExecutionResult> iterator = res = autoCommit ? this.executeQueries(statement) : this.begin(statement);
            if (res.hasNext()) {
                ExecutionResult result = res.next();
                return result;
            }
            return ExecutionResult.EMPTY_RESULT;
        }
        catch (ResourceException e) {
            throw new SQLException(e.getStatus().getReasonPhrase(), e);
        }
    }

    @Override
    public void stop() throws Exception {
        ((Filter)this.txResource.getNext()).stop();
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public void commit() throws SQLException {
        this.commit(NO_STATEMENTS);
    }
}

