/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.roborumble.battlesengine;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import net.sf.robocode.io.Logger;
import net.sf.robocode.roborumble.battlesengine.CompetitionsSelector;
import net.sf.robocode.roborumble.util.PropertiesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrepareBattles {
    private final String botsrepository;
    private final String participantsfile;
    private final String battlesfile;
    private final int numbattles;
    private final CompetitionsSelector size;
    private final String runonly;
    private final Properties generalratings;
    private final Properties miniratings;
    private final Properties microratings;
    private final Properties nanoratings;
    private final String priority;
    private final int prioritynum;
    private final int meleebots;

    public PrepareBattles(String propertiesfile) {
        Properties parameters = PropertiesUtil.getProperties(propertiesfile);
        this.botsrepository = parameters.getProperty("BOTSREP", "");
        this.participantsfile = parameters.getProperty("PARTICIPANTSFILE", "");
        this.battlesfile = parameters.getProperty("INPUT", "");
        this.numbattles = Integer.parseInt(parameters.getProperty("NUMBATTLES", "100"));
        String sizesfile = parameters.getProperty("CODESIZEFILE", "");
        this.size = new CompetitionsSelector(sizesfile, this.botsrepository);
        this.runonly = parameters.getProperty("RUNONLY", "GENERAL");
        this.prioritynum = Integer.parseInt(parameters.getProperty("BATTLESPERBOT", "500"));
        this.meleebots = Integer.parseInt(parameters.getProperty("MELEEBOTS", "10"));
        this.generalratings = PropertiesUtil.getProperties(parameters.getProperty("RATINGS.GENERAL", ""));
        this.miniratings = PropertiesUtil.getProperties(parameters.getProperty("RATINGS.MINIBOTS", ""));
        this.microratings = PropertiesUtil.getProperties(parameters.getProperty("RATINGS.MICROBOTS", ""));
        this.nanoratings = PropertiesUtil.getProperties(parameters.getProperty("RATINGS.NANOBOTS", ""));
        this.priority = parameters.getProperty("PRIORITYBATTLESFILE", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createBattlesList() {
        PrintStream outtxt;
        Vector<String> names = new Vector<String>();
        BufferedReader br = null;
        try {
            String record;
            FileReader fr = new FileReader(this.participantsfile);
            br = new BufferedReader(fr);
            while ((record = br.readLine()) != null) {
                if (record.indexOf(",") == -1) continue;
                String name = record.substring(0, record.indexOf(","));
                String jar = name.replace(' ', '_') + ".jar";
                boolean exists = new File(this.botsrepository + jar).exists();
                if (!exists || !(this.runonly.equals("MINI") && this.size.checkCompetitorsForSize(name, name, 1500L) || this.runonly.equals("MICRO") && this.size.checkCompetitorsForSize(name, name, 750L) || this.runonly.equals("NANO") && this.size.checkCompetitorsForSize(name, name, 250L)) && (this.runonly.equals("MINI") || this.runonly.equals("MICRO") || this.runonly.equals("NANO"))) continue;
                names.add(name);
            }
        }
        catch (IOException e) {
            System.out.println("Participants file not found ... Aborting");
            System.out.println(e);
            boolean record = false;
            return record;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ignored) {}
            }
        }
        try {
            outtxt = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.battlesfile)), false);
        }
        catch (IOException e) {
            System.out.println("Not able to open battles file " + this.battlesfile + " ... Aborting");
            System.out.println(e);
            return false;
        }
        Random random = new Random();
        int count = 0;
        while (count < this.numbattles && names.size() > 1) {
            int bot2;
            int bot1 = random.nextInt(names.size());
            if (bot1 == (bot2 = random.nextInt(names.size()))) continue;
            outtxt.println((String)names.get(bot1) + "," + (String)names.get(bot2) + "," + this.runonly);
            ++count;
        }
        outtxt.close();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createSmartBattlesList() {
        int count;
        PrintStream outtxt;
        String record2;
        FileReader fr;
        Vector<String> namesall = new Vector<String>();
        Vector<String> namesmini = new Vector<String>();
        Vector<String> namesmicro = new Vector<String>();
        Vector<String> namesnano = new Vector<String>();
        Vector<String> priorityall = new Vector<String>();
        Vector<String> prioritymini = new Vector<String>();
        Vector<String> prioritymicro = new Vector<String>();
        Vector<String> prioritynano = new Vector<String>();
        Vector<String> prioritarybattles = new Vector<String>();
        BufferedReader br = null;
        try {
            fr = new FileReader(this.participantsfile);
            br = new BufferedReader(fr);
            while ((record2 = br.readLine()) != null) {
                if (record2.indexOf(",") == -1) continue;
                String name = record2.substring(0, record2.indexOf(","));
                String jar = name.replace(' ', '_') + ".jar";
                boolean exists = new File(this.botsrepository + jar).exists();
                if (!exists) continue;
                namesall.add(name);
                if (this.size.checkCompetitorsForSize(name, name, 1500L)) {
                    namesmini.add(name);
                }
                if (this.size.checkCompetitorsForSize(name, name, 750L)) {
                    namesmicro.add(name);
                }
                if (this.size.checkCompetitorsForSize(name, name, 250L)) {
                    namesnano.add(name);
                }
                if (this.robothaspriority(name, this.generalratings)) {
                    priorityall.add(name);
                }
                if (this.size.checkCompetitorsForSize(name, name, 1500L) && this.robothaspriority(name, this.miniratings)) {
                    prioritymini.add(name);
                }
                if (this.size.checkCompetitorsForSize(name, name, 750L) && this.robothaspriority(name, this.microratings)) {
                    prioritymicro.add(name);
                }
                if (!this.size.checkCompetitorsForSize(name, name, 250L) || !this.robothaspriority(name, this.nanoratings)) continue;
                prioritynano.add(name);
            }
        }
        catch (IOException e) {
            System.out.println("Participants file not found ... Aborting");
            System.out.println(e);
            boolean record2 = false;
            return record2;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ignored) {}
            }
        }
        br = null;
        try {
            fr = new FileReader(this.priority);
            br = new BufferedReader(fr);
            while ((record2 = br.readLine()) != null) {
                String[] items = record2.split(",");
                if (items.length != 3) continue;
                String jar1 = items[0].replace(' ', '_') + ".jar";
                boolean exists1 = new File(this.botsrepository + jar1).exists();
                String jar2 = items[1].replace(' ', '_') + ".jar";
                boolean exists2 = new File(this.botsrepository + jar2).exists();
                if (!exists1 || !exists2) continue;
                prioritarybattles.add(record2);
            }
        }
        catch (IOException e) {
            System.out.println("Prioritary battles file not found ...  ");
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ignored) {}
            }
        }
        File r = new File(this.priority);
        if (r.exists() && !r.delete()) {
            Logger.logError((String)("Cannot delete: " + r));
        }
        try {
            outtxt = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.battlesfile)), false);
        }
        catch (IOException e) {
            System.out.println("Not able to open battles file " + this.battlesfile + " ... Aborting");
            System.out.println(e);
            return false;
        }
        Random random = new Random();
        for (count = 0; count < this.numbattles && count < prioritarybattles.size(); ++count) {
            String battle = (String)prioritarybattles.get(count);
            outtxt.println(battle);
        }
        while (count < this.numbattles && namesall.size() > 1) {
            String[] bots = priorityall.size() > 0 ? this.getbots(priorityall, namesall, random) : (prioritymini.size() > 0 && namesmini.size() > 1 ? this.getbots(prioritymini, namesmini, random) : (prioritymicro.size() > 0 && namesmicro.size() > 1 ? this.getbots(prioritymicro, namesmicro, random) : (prioritynano.size() > 0 && namesnano.size() > 1 ? this.getbots(prioritynano, namesnano, random) : this.getbots(namesall, namesall, random))));
            if (bots == null) continue;
            outtxt.println(bots[0] + "," + bots[1] + "," + this.runonly);
            ++count;
        }
        outtxt.close();
        return true;
    }

    private String[] getbots(Vector<String> list1, Vector<String> list2, Random rand) {
        int bot1 = rand.nextInt(list1.size());
        int bot2 = rand.nextInt(list2.size());
        while (list1.get(bot1).equals(list2.get(bot2))) {
            bot1 = rand.nextInt(list1.size());
            bot2 = rand.nextInt(list2.size());
        }
        String[] bots = new String[]{list1.get(bot1), list2.get(bot2)};
        return bots;
    }

    private boolean robothaspriority(String name, Properties ratings) {
        if (ratings == null) {
            return false;
        }
        String bot = name.replaceAll(" ", "_");
        String values = ratings.getProperty(bot);
        if (values == null) {
            return true;
        }
        String[] value = values.split(",");
        double battles = Double.parseDouble(value[1]);
        return battles < (double)this.prioritynum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createMeleeBattlesList() {
        PrintStream outtxt;
        String record2;
        FileReader fr;
        Vector<String> namesall = new Vector<String>();
        Vector<String> namesmini = new Vector<String>();
        Vector<String> namesmicro = new Vector<String>();
        Vector<String> namesnano = new Vector<String>();
        Vector<String> priorityall = new Vector<String>();
        Vector<String> prioritymini = new Vector<String>();
        Vector<String> prioritymicro = new Vector<String>();
        Vector<String> prioritynano = new Vector<String>();
        Vector<String[]> prioritypairs = new Vector<String[]>();
        BufferedReader br = null;
        try {
            fr = new FileReader(this.participantsfile);
            br = new BufferedReader(fr);
            while ((record2 = br.readLine()) != null) {
                if (record2.indexOf(",") == -1) continue;
                String name = record2.substring(0, record2.indexOf(","));
                String jar = name.replace(' ', '_') + ".jar";
                boolean exists = new File(this.botsrepository + jar).exists();
                if (!exists) continue;
                namesall.add(name);
                if (this.size.checkCompetitorsForSize(name, name, 1500L)) {
                    namesmini.add(name);
                }
                if (this.size.checkCompetitorsForSize(name, name, 750L)) {
                    namesmicro.add(name);
                }
                if (this.size.checkCompetitorsForSize(name, name, 250L)) {
                    namesnano.add(name);
                }
                if (this.robothaspriority(name, this.generalratings)) {
                    priorityall.add(name);
                }
                if (this.size.checkCompetitorsForSize(name, name, 1500L) && this.robothaspriority(name, this.miniratings)) {
                    prioritymini.add(name);
                }
                if (this.size.checkCompetitorsForSize(name, name, 750L) && this.robothaspriority(name, this.microratings)) {
                    prioritymicro.add(name);
                }
                if (!this.size.checkCompetitorsForSize(name, name, 250L) || !this.robothaspriority(name, this.nanoratings)) continue;
                prioritynano.add(name);
            }
        }
        catch (IOException e) {
            System.out.println("Participants file not found ... Aborting");
            System.out.println(e);
            boolean record2 = false;
            return record2;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ignored) {}
            }
        }
        br = null;
        try {
            fr = new FileReader(this.priority);
            br = new BufferedReader(fr);
            while ((record2 = br.readLine()) != null) {
                String[] items = record2.split(",");
                if (items.length != 3) continue;
                String jar1 = items[0].replace(' ', '_') + ".jar";
                boolean exists1 = new File(this.botsrepository + jar1).exists();
                String jar2 = items[1].replace(' ', '_') + ".jar";
                boolean exists2 = new File(this.botsrepository + jar2).exists();
                if (!exists1 || !exists2) continue;
                prioritypairs.add(items);
            }
        }
        catch (IOException e) {
            System.out.println("Priority battles file not found ...  ");
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
        }
        File r = new File(this.priority);
        if (!r.delete()) {
            System.out.println("Cannot delete the priority battles file " + this.priority);
        }
        try {
            outtxt = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.battlesfile)), false);
        }
        catch (IOException e) {
            System.out.println("Not able to open battles file " + this.battlesfile + " ... Aborting");
            System.out.println(e);
            return false;
        }
        Random random = new Random();
        int count = 0;
        while (count < this.numbattles && namesall.size() > this.meleebots) {
            String[] bots = null;
            if (count < prioritypairs.size()) {
                String[] prioritybots = (String[])prioritypairs.get(count);
                bots = this.getMeleeBots(prioritybots[0], prioritybots[1], namesall, random);
            } else if (priorityall.size() > 0 && namesall.size() >= this.meleebots) {
                bots = this.getmeleebots(priorityall, namesall, random);
            } else if (prioritymini.size() > 0 && namesmini.size() >= this.meleebots) {
                bots = this.getmeleebots(prioritymini, namesmini, random);
            } else if (prioritymicro.size() > 0 && namesmicro.size() >= this.meleebots) {
                bots = this.getmeleebots(prioritymicro, namesmicro, random);
            } else if (prioritynano.size() > 0 && namesnano.size() >= this.meleebots) {
                bots = this.getmeleebots(prioritynano, namesnano, random);
            } else if (namesall.size() >= this.meleebots) {
                bots = this.getmeleebots(namesall, namesall, random);
            }
            if (bots == null) continue;
            StringBuilder battle = new StringBuilder(bots[0]);
            for (int i = 1; i < bots.length; ++i) {
                battle.append(',').append(bots[i]);
            }
            battle.append(',').append(this.runonly);
            outtxt.println(battle);
            ++count;
        }
        outtxt.close();
        return true;
    }

    private String[] getmeleebots(Vector<String> list1, Vector<String> list2, Random rand) {
        String[] bots = new String[this.meleebots];
        bots[0] = list1.get(rand.nextInt(list1.size()));
        int count = 1;
        while (count < this.meleebots) {
            bots[count] = list2.get(rand.nextInt(list2.size()));
            boolean exists = false;
            for (int i = 0; i < count; ++i) {
                if (!bots[i].equals(bots[count])) continue;
                exists = true;
            }
            if (exists) continue;
            ++count;
        }
        return bots;
    }

    private String[] getMeleeBots(String bot1, String bot2, Vector<String> list2, Random rand) {
        String[] bots = new String[this.meleebots];
        bots[0] = bot1;
        bots[1] = bot2;
        int count = 2;
        while (count < this.meleebots) {
            bots[count] = list2.get(rand.nextInt(list2.size()));
            boolean exists = false;
            for (int i = 0; i < count; ++i) {
                if (!bots[i].equals(bots[count])) continue;
                exists = true;
            }
            if (exists) continue;
            ++count;
        }
        return bots;
    }
}

