/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.roborumble.battlesengine;

import codesize.Codesize;
import java.io.File;
import java.util.Properties;
import net.sf.robocode.roborumble.util.PropertiesUtil;

public class CompetitionsSelector {
    private final String repository;
    private final String sizesfile;
    private final Properties sizes;

    public CompetitionsSelector(String sizesfile, String repository) {
        this.repository = repository;
        this.sizesfile = sizesfile;
        this.sizes = PropertiesUtil.getProperties(sizesfile);
    }

    public boolean checkCompetitorsForSize(String bot1, String bot2, long maxsize) {
        File f;
        String bot1name = bot1.replace(' ', '_');
        String bot2name = bot2.replace(' ', '_');
        long size1 = Long.parseLong(this.sizes.getProperty(bot1name, "0"));
        long size2 = Long.parseLong(this.sizes.getProperty(bot2name, "0"));
        boolean fileneedsupdate = false;
        if (size1 == 0L) {
            fileneedsupdate = true;
            f = new File(this.repository + bot1name + ".jar");
            if (f.exists()) {
                Codesize.Item s1 = Codesize.processZipFile((File)f);
                if (s1 != null) {
                    size1 = s1.getCodeSize();
                }
                if (size1 != 0L) {
                    this.sizes.setProperty(bot1name, Long.toString(size1));
                }
            }
        }
        if (size2 == 0L) {
            fileneedsupdate = true;
            f = new File(this.repository + bot2name + ".jar");
            if (f.exists()) {
                Codesize.Item s2 = Codesize.processZipFile((File)f);
                if (s2 != null) {
                    size2 = s2.getCodeSize();
                }
                if (size2 != 0L) {
                    this.sizes.setProperty(bot2name, Long.toString(size2));
                }
            }
        }
        if (fileneedsupdate && size1 != 0L && size2 != 0L) {
            PropertiesUtil.storeProperties(this.sizes, this.sizesfile, "Bots code size");
        }
        return size1 != 0L && size1 < maxsize && size2 != 0L && size2 < maxsize;
    }
}

