/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.host.security;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import net.sf.robocode.host.security.RobocodePermission;

public class SecureInputStream
extends InputStream {
    private RobocodePermission inputPermission = null;
    private InputStream in = null;

    public SecureInputStream(InputStream in) {
        this.in = in;
        this.inputPermission = new RobocodePermission("System.in");
    }

    public final int available() throws IOException {
        this.checkAccess();
        return this.in.available();
    }

    private void checkAccess() {
        AccessController.checkPermission(this.inputPermission);
    }

    public final void close() throws IOException {
        this.checkAccess();
        this.in.close();
    }

    public final synchronized void mark(int readlimit) {
        this.checkAccess();
        this.in.mark(readlimit);
    }

    public final boolean markSupported() {
        this.checkAccess();
        return this.in.markSupported();
    }

    public final int read() throws IOException {
        this.checkAccess();
        return this.in.read();
    }

    public final int read(byte[] b) throws IOException {
        this.checkAccess();
        return this.in.read(b);
    }

    public final int read(byte[] b, int off, int len) throws IOException {
        this.checkAccess();
        return this.in.read(b, off, len);
    }

    public final synchronized void reset() throws IOException {
        this.checkAccess();
        this.in.reset();
    }

    public final long skip(long n) throws IOException {
        this.checkAccess();
        return this.in.skip(n);
    }
}

