/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.host.security;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Set;
import net.sf.robocode.io.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassAnalyzer {
    private static final byte CONSTANT_Class = 7;
    private static final byte CONSTANT_Fieldref = 9;
    private static final byte CONSTANT_Methodref = 10;
    private static final byte CONSTANT_InterfaceMethodref = 11;
    private static final byte CONSTANT_String = 8;
    private static final byte CONSTANT_Integer = 3;
    private static final byte CONSTANT_Float = 4;
    private static final byte CONSTANT_Long = 5;
    private static final byte CONSTANT_Double = 6;
    private static final byte CONSTANT_NameAndType = 12;
    private static final byte CONSTANT_Utf8 = 1;

    public static void getReferencedClasses(ByteBuffer classFile, Set<String> collection) {
        String[] strings;
        ArrayList<Integer> classNameIndexes = new ArrayList<Integer>();
        try {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(classFile.array(), 0, classFile.limit()));
            long magic = in.readInt();
            if (magic != -889275714L) {
                Logger.logError((String)"Not a class file!");
                return;
            }
            in.readUnsignedShort();
            in.readUnsignedShort();
            int constant_pool_count = in.readUnsignedShort();
            strings = new String[constant_pool_count];
            block11: for (int i = 1; i < constant_pool_count; ++i) {
                byte tag = in.readByte();
                switch (tag) {
                    case 7: {
                        int name_index = in.readUnsignedShort();
                        classNameIndexes.add(name_index);
                        continue block11;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        in.readUnsignedShort();
                        in.readUnsignedShort();
                        continue block11;
                    }
                    case 8: {
                        in.readUnsignedShort();
                        continue block11;
                    }
                    case 3: 
                    case 4: {
                        in.readInt();
                        continue block11;
                    }
                    case 5: 
                    case 6: {
                        in.readInt();
                        in.readInt();
                        ++i;
                        continue block11;
                    }
                    case 12: {
                        in.readUnsignedShort();
                        in.readUnsignedShort();
                        continue block11;
                    }
                    case 1: {
                        String utf8_string;
                        strings[i] = utf8_string = in.readUTF();
                    }
                }
            }
        }
        catch (IOException e) {
            return;
        }
        for (Integer classNameIndex : classNameIndexes) {
            String className = strings[classNameIndex].replace('\\', '.').replace('/', '.');
            if (className.indexOf("[") == 0 || collection.contains(className)) continue;
            collection.add(className);
        }
    }
}

