/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.host.io;

import java.io.IOException;
import java.io.OutputStream;
import net.sf.robocode.host.io.BufferedPipedInputStream;

public class BufferedPipedOutputStream
extends OutputStream {
    private final Object monitor = new Object();
    private final byte[] buf;
    private volatile int readIndex;
    private volatile int writeIndex;
    private volatile boolean waiting;
    private volatile boolean closed;
    private BufferedPipedInputStream in;
    private final boolean skipLines;

    public BufferedPipedOutputStream(int bufferSize, boolean skipLines) {
        this.buf = new byte[bufferSize];
        this.skipLines = skipLines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int b) throws IOException {
        Object object = this.monitor;
        synchronized (object) {
            if (this.closed) {
                throw new IOException("Stream is closed.");
            }
            this.buf[this.writeIndex++] = (byte)(b & 0xFF);
            if (this.writeIndex == this.buf.length) {
                this.writeIndex = 0;
            }
            if (this.writeIndex == this.readIndex) {
                if (this.skipLines) {
                    boolean writeIndexReached = false;
                    while (this.buf[this.readIndex] != 10) {
                        ++this.readIndex;
                        if (this.readIndex == this.buf.length) {
                            this.readIndex = 0;
                        }
                        if (this.readIndex != this.writeIndex) continue;
                        writeIndexReached = true;
                    }
                    if (!writeIndexReached) {
                        ++this.readIndex;
                        if (this.readIndex == this.buf.length) {
                            this.readIndex = 0;
                        }
                    }
                } else {
                    throw new IOException("Buffer is full.");
                }
            }
            if (this.waiting) {
                this.monitor.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int read() throws IOException {
        Object object = this.monitor;
        synchronized (object) {
            while (this.readIndex == this.writeIndex) {
                this.waiting = true;
                try {
                    if (!this.closed) {
                        this.monitor.wait(10000L);
                    }
                    if (!this.closed) continue;
                    return -1;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    IOException ioException = new IOException("read interrupted");
                    ioException.initCause(e);
                    throw ioException;
                }
            }
            byte result = this.buf[this.readIndex++];
            if (this.readIndex == this.buf.length) {
                this.readIndex = 0;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off >= b.length || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int first = this.read();
        if (first == -1) {
            return -1;
        }
        b[off] = (byte)(first & 0xFF);
        int count = 1;
        Object object = this.monitor;
        synchronized (object) {
            for (int i = 1; this.readIndex != this.writeIndex && i < len; ++i) {
                b[off + i] = this.buf[this.readIndex++];
                ++count;
                if (this.readIndex != this.buf.length) continue;
                this.readIndex = 0;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int available() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.writeIndex == this.readIndex) {
                return 0;
            }
            if (this.writeIndex > this.readIndex) {
                return this.writeIndex - this.readIndex;
            }
            return this.buf.length - this.readIndex + this.writeIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedPipedInputStream getInputStream() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.in == null) {
                this.in = new BufferedPipedInputStream(this);
            }
            return this.in;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.monitor;
        synchronized (object) {
            this.closed = true;
            if (this.waiting) {
                this.monitor.notifyAll();
            }
        }
    }
}

