/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.host;

import net.sf.robocode.core.Container;
import net.sf.robocode.host.ICpuManager;
import net.sf.robocode.io.Logger;
import net.sf.robocode.settings.ISettingsManager;
import net.sf.robocode.ui.IWindowManager;

public class CpuManager
implements ICpuManager {
    private static final int APPROXIMATE_CYCLES_ALLOWED = 6250;
    private static final int TEST_PERIOD_MILLIS = 5000;
    private long cpuConstant = -1L;
    private final ISettingsManager properties;

    public CpuManager(ISettingsManager properties) {
        this.properties = properties;
    }

    public long getCpuConstant() {
        if (this.cpuConstant == -1L) {
            this.cpuConstant = this.properties.getCpuConstant();
            if (this.cpuConstant == -1L) {
                this.calculateCpuConstant();
            }
        }
        return this.cpuConstant;
    }

    public void calculateCpuConstant() {
        this.setStatus("Estimating CPU speed, please wait...");
        this.setCpuConstant();
        Logger.logMessage((String)("Each robot will be allowed a maximum of " + this.cpuConstant + " nanoseconds per turn on this system."));
        this.properties.setCpuConstant(this.cpuConstant);
        this.properties.saveProperties();
        this.setStatus("");
    }

    private void setCpuConstant() {
        long count = 0L;
        double d = 0.0;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 5000L) {
            d += Math.hypot(Math.sqrt(Math.abs(Math.log(Math.atan(Math.random())))), Math.cbrt(Math.abs(Math.random() * 10.0))) / Math.exp(Math.random());
            ++count;
        }
        if (d == 0.0) {
            Logger.logMessage((String)"bingo!");
        }
        this.cpuConstant = Math.max(1L, (long)(3.125E13 / (double)count));
    }

    private void setStatus(String message) {
        IWindowManager windowManager = (IWindowManager)Container.getComponent(IWindowManager.class);
        if (windowManager != null) {
            windowManager.setStatus(message);
        }
    }
}

