/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.serialization;

import java.io.IOException;
import java.io.Writer;
import java.text.StringCharacterIterator;
import java.util.Stack;

public class XmlWriter {
    final Writer writer;
    final Stack<String> elements = new Stack();
    boolean headClosed = true;
    boolean innerElement = false;
    boolean indent = true;

    public XmlWriter(Writer writer, boolean indent) {
        this.writer = writer;
        this.indent = indent;
    }

    public void startDocument() throws IOException {
        this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
    }

    public void startElement(String name) throws IOException {
        this.closeHead();
        this.indent(this.elements.size());
        this.elements.push(name);
        this.writer.write(60);
        this.writer.write(XmlWriter.encode(name));
        this.headClosed = false;
        this.innerElement = false;
    }

    public void writeAttribute(String name, String value) throws IOException {
        if (value != null) {
            this.writer.write(32);
            this.writer.write(XmlWriter.encode(name));
            this.writer.write("=\"");
            this.writer.write(XmlWriter.encode(value));
            this.writer.write(34);
        }
    }

    public void writeAttribute(String name, boolean value) throws IOException {
        this.writeAttribute(name, Boolean.toString(value));
    }

    public void writeAttribute(String name, long value) throws IOException {
        this.writeAttribute(name, Long.toString(value));
    }

    public void writeAttribute(String name, double value) throws IOException {
        this.writeAttribute(name, Double.toString(value));
    }

    public void endElement() throws IOException {
        String name = this.elements.pop();
        if (this.innerElement || this.headClosed) {
            this.closeHead();
            this.indent(this.elements.size());
            this.writer.write("</");
            this.writer.write(XmlWriter.encode(name));
            this.writer.write(">");
        } else {
            this.writer.write("/>");
            this.headClosed = true;
        }
        this.newline();
        this.innerElement = true;
    }

    private void newline() throws IOException {
        if (this.indent) {
            this.writer.write("\n");
        }
    }

    private void closeHead() throws IOException {
        if (!this.headClosed) {
            this.writer.write(62);
            this.newline();
            this.headClosed = true;
        }
    }

    private void indent(int level) throws IOException {
        if (this.indent) {
            for (int i = 0; i < level; ++i) {
                this.writer.write("\t");
            }
        }
    }

    public static String encode(String text) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(text);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                result.append("&lt;");
            } else if (character == '>') {
                result.append("&gt;");
            } else if (character == '&') {
                result.append("&amp;");
            } else if (character == '\"') {
                result.append("&quot;");
            } else if (character == '\n') {
                result.append("&#xA;");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }
}

