/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.peer;

import java.io.Serializable;
import java.nio.ByteBuffer;
import net.sf.robocode.serialization.ISerializableHelper;
import net.sf.robocode.serialization.RbSerializer;

public class TeamMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final String sender;
    public final String recipient;
    public final byte[] message;

    public TeamMessage(String sender, String recipient, byte[] message) {
        this.sender = sender;
        this.recipient = recipient;
        this.message = message;
    }

    static ISerializableHelper createHiddenSerializer() {
        return new SerializableHelper();
    }

    private static class SerializableHelper
    implements ISerializableHelper {
        private SerializableHelper() {
        }

        public int sizeOf(RbSerializer serializer, Object object) {
            TeamMessage obj = (TeamMessage)object;
            int s = serializer.sizeOf(obj.sender);
            int r = serializer.sizeOf(obj.recipient);
            int m = serializer.sizeOf(obj.message);
            return 1 + s + r + m;
        }

        public void serialize(RbSerializer serializer, ByteBuffer buffer, Object object) {
            TeamMessage obj = (TeamMessage)object;
            serializer.serialize(buffer, obj.sender);
            serializer.serialize(buffer, obj.recipient);
            serializer.serialize(buffer, obj.message);
        }

        public Object deserialize(RbSerializer serializer, ByteBuffer buffer) {
            String sender = serializer.deserializeString(buffer);
            String recipient = serializer.deserializeString(buffer);
            byte[] message = serializer.deserializeBytes(buffer);
            return new TeamMessage(sender, recipient, message);
        }
    }
}

