/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.peer;

import java.io.Serializable;
import java.nio.ByteBuffer;
import net.sf.robocode.serialization.ISerializableHelper;
import net.sf.robocode.serialization.RbSerializer;

public class BulletCommand
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final double power;
    private final boolean fireAssistValid;
    private final double fireAssistAngle;
    private final int bulletId;

    public BulletCommand(double power, boolean fireAssistValid, double fireAssistAngle, int bulletId) {
        this.fireAssistValid = fireAssistValid;
        this.fireAssistAngle = fireAssistAngle;
        this.bulletId = bulletId;
        this.power = power;
    }

    public boolean isFireAssistValid() {
        return this.fireAssistValid;
    }

    public int getBulletId() {
        return this.bulletId;
    }

    public double getPower() {
        return this.power;
    }

    public double getFireAssistAngle() {
        return this.fireAssistAngle;
    }

    static ISerializableHelper createHiddenSerializer() {
        return new SerializableHelper();
    }

    private static class SerializableHelper
    implements ISerializableHelper {
        private SerializableHelper() {
        }

        public int sizeOf(RbSerializer serializer, Object object) {
            return 22;
        }

        public void serialize(RbSerializer serializer, ByteBuffer buffer, Object object) {
            BulletCommand obj = (BulletCommand)object;
            serializer.serialize(buffer, obj.power);
            serializer.serialize(buffer, obj.fireAssistValid);
            serializer.serialize(buffer, obj.fireAssistAngle);
            serializer.serialize(buffer, obj.bulletId);
        }

        public Object deserialize(RbSerializer serializer, ByteBuffer buffer) {
            double power = buffer.getDouble();
            boolean fireAssistValid = serializer.deserializeBoolean(buffer);
            double fireAssistAngle = buffer.getDouble();
            int bulletId = buffer.getInt();
            return new BulletCommand(power, fireAssistValid, fireAssistAngle, bulletId);
        }
    }
}

