/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.host;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import net.sf.robocode.peer.IRobotStatics;
import net.sf.robocode.repository.IRobotRepositoryItem;
import net.sf.robocode.security.HiddenAccess;
import net.sf.robocode.serialization.ISerializableHelper;
import net.sf.robocode.serialization.RbSerializer;
import robocode.BattleRules;
import robocode.control.RobotSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RobotStatics
implements IRobotStatics,
Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean isJuniorRobot;
    private final boolean isInteractiveRobot;
    private final boolean isPaintRobot;
    private final boolean isAdvancedRobot;
    private final boolean isTeamRobot;
    private final boolean isTeamLeader;
    private final boolean isDroid;
    private final String name;
    private final String shortName;
    private final String veryShortName;
    private final String fullClassName;
    private final String shortClassName;
    private final BattleRules battleRules;
    private final String[] teammates;
    private final String teamName;
    private final int index;
    private final int contestantIndex;

    public RobotStatics(RobotSpecification robotSpecification, int duplicate, boolean isLeader, BattleRules rules, String teamName, List<String> teamMembers, int index, int contestantIndex) {
        IRobotRepositoryItem specification = (IRobotRepositoryItem)HiddenAccess.getFileSpecification((RobotSpecification)robotSpecification);
        this.shortClassName = specification.getShortClassName();
        this.fullClassName = specification.getFullClassName();
        if (duplicate >= 0) {
            String countString = " (" + (duplicate + 1) + ')';
            this.name = specification.getUniqueFullClassNameWithVersion() + countString;
            this.shortName = specification.getUniqueShortClassNameWithVersion() + countString;
            this.veryShortName = specification.getUniqueVeryShortClassNameWithVersion() + countString;
        } else {
            this.name = specification.getUniqueFullClassNameWithVersion();
            this.shortName = specification.getUniqueShortClassNameWithVersion();
            this.veryShortName = specification.getUniqueVeryShortClassNameWithVersion();
        }
        this.isJuniorRobot = specification.isJuniorRobot();
        this.isInteractiveRobot = specification.isInteractiveRobot();
        this.isPaintRobot = specification.isPaintRobot();
        this.isAdvancedRobot = specification.isAdvancedRobot();
        this.isTeamRobot = specification.isTeamRobot();
        this.isDroid = specification.isDroid();
        this.isTeamLeader = isLeader;
        this.battleRules = rules;
        this.index = index;
        this.contestantIndex = contestantIndex;
        if (teamMembers != null) {
            ArrayList<String> list = new ArrayList<String>();
            for (String mate : teamMembers) {
                if (this.name.equals(mate)) continue;
                list.add(mate);
            }
            this.teammates = list.toArray(new String[0]);
            this.teamName = teamName;
        } else {
            this.teammates = null;
            this.teamName = this.name;
        }
    }

    RobotStatics(boolean isJuniorRobot, boolean isInteractiveRobot, boolean isPaintRobot, boolean isAdvancedRobot, boolean isTeamRobot, boolean isTeamLeader, boolean isDroid, String name, String shortName, String veryShortName, String fullClassName, String shortClassName, BattleRules battleRules, String[] teammates, String teamName, int index, int contestantIndex) {
        this.isJuniorRobot = isJuniorRobot;
        this.isInteractiveRobot = isInteractiveRobot;
        this.isPaintRobot = isPaintRobot;
        this.isAdvancedRobot = isAdvancedRobot;
        this.isTeamRobot = isTeamRobot;
        this.isTeamLeader = isTeamLeader;
        this.isDroid = isDroid;
        this.name = name;
        this.shortName = shortName;
        this.veryShortName = veryShortName;
        this.fullClassName = fullClassName;
        this.shortClassName = shortClassName;
        this.battleRules = battleRules;
        this.teammates = teammates;
        this.teamName = teamName;
        this.index = index;
        this.contestantIndex = contestantIndex;
    }

    public boolean isJuniorRobot() {
        return this.isJuniorRobot;
    }

    public boolean isInteractiveRobot() {
        return this.isInteractiveRobot;
    }

    public boolean isPaintRobot() {
        return this.isPaintRobot;
    }

    public boolean isAdvancedRobot() {
        return this.isAdvancedRobot;
    }

    public boolean isTeamRobot() {
        return this.isTeamRobot;
    }

    public boolean isTeamLeader() {
        return this.isTeamLeader;
    }

    public boolean isDroid() {
        return this.isDroid;
    }

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getVeryShortName() {
        return this.veryShortName;
    }

    public String getFullClassName() {
        return this.fullClassName;
    }

    public String getShortClassName() {
        return this.shortClassName;
    }

    public BattleRules getBattleRules() {
        return this.battleRules;
    }

    public String[] getTeammates() {
        return this.teammates == null ? null : (String[])this.teammates.clone();
    }

    public String getTeamName() {
        return this.teamName;
    }

    public int getIndex() {
        return this.index;
    }

    public int getContestIndex() {
        return this.contestantIndex;
    }

    static ISerializableHelper createHiddenSerializer() {
        return new SerializableHelper();
    }

    private static class SerializableHelper
    implements ISerializableHelper {
        private SerializableHelper() {
        }

        public int sizeOf(RbSerializer serializer, Object object) {
            RobotStatics obj = (RobotStatics)object;
            int size = 8 + serializer.sizeOf(obj.name) + serializer.sizeOf(obj.shortName) + serializer.sizeOf(obj.veryShortName) + serializer.sizeOf(obj.fullClassName) + serializer.sizeOf(obj.shortClassName) + 20 + 8 + 8;
            if (obj.teammates != null) {
                for (String mate : obj.teammates) {
                    size += serializer.sizeOf(mate);
                }
            }
            size += 4;
            return size += serializer.sizeOf(obj.teamName);
        }

        public void serialize(RbSerializer serializer, ByteBuffer buffer, Object object) {
            RobotStatics obj = (RobotStatics)object;
            serializer.serialize(buffer, obj.isJuniorRobot);
            serializer.serialize(buffer, obj.isInteractiveRobot);
            serializer.serialize(buffer, obj.isPaintRobot);
            serializer.serialize(buffer, obj.isAdvancedRobot);
            serializer.serialize(buffer, obj.isTeamRobot);
            serializer.serialize(buffer, obj.isTeamLeader);
            serializer.serialize(buffer, obj.isDroid);
            serializer.serialize(buffer, obj.name);
            serializer.serialize(buffer, obj.shortName);
            serializer.serialize(buffer, obj.veryShortName);
            serializer.serialize(buffer, obj.fullClassName);
            serializer.serialize(buffer, obj.shortClassName);
            serializer.serialize(buffer, obj.battleRules.getBattlefieldWidth());
            serializer.serialize(buffer, obj.battleRules.getBattlefieldHeight());
            serializer.serialize(buffer, obj.battleRules.getNumRounds());
            serializer.serialize(buffer, obj.battleRules.getGunCoolingRate());
            serializer.serialize(buffer, obj.battleRules.getInactivityTime());
            if (obj.teammates != null) {
                for (String mate : obj.teammates) {
                    serializer.serialize(buffer, mate);
                }
            }
            buffer.putInt(-1);
            serializer.serialize(buffer, obj.teamName);
            serializer.serialize(buffer, obj.index);
            serializer.serialize(buffer, obj.contestantIndex);
        }

        public Object deserialize(RbSerializer serializer, ByteBuffer buffer) {
            boolean isJuniorRobot = serializer.deserializeBoolean(buffer);
            boolean isInteractiveRobot = serializer.deserializeBoolean(buffer);
            boolean isPaintRobot = serializer.deserializeBoolean(buffer);
            boolean isAdvancedRobot = serializer.deserializeBoolean(buffer);
            boolean isTeamRobot = serializer.deserializeBoolean(buffer);
            boolean isTeamLeader = serializer.deserializeBoolean(buffer);
            boolean isDroid = serializer.deserializeBoolean(buffer);
            String name = serializer.deserializeString(buffer);
            String shortName = serializer.deserializeString(buffer);
            String veryShortName = serializer.deserializeString(buffer);
            String fullClassName = serializer.deserializeString(buffer);
            String shortClassName = serializer.deserializeString(buffer);
            BattleRules battleRules = HiddenAccess.createRules((int)serializer.deserializeInt(buffer), (int)serializer.deserializeInt(buffer), (int)serializer.deserializeInt(buffer), (double)serializer.deserializeDouble(buffer), (long)serializer.deserializeLong(buffer));
            ArrayList<String> teammates = new ArrayList<String>();
            String item = serializer.deserializeString(buffer);
            if (item == null) {
                teammates = null;
            }
            while (item != null) {
                if (item instanceof String) {
                    teammates.add(item);
                }
                item = serializer.deserializeString(buffer);
            }
            String teamName = serializer.deserializeString(buffer);
            int index = serializer.deserializeInt(buffer);
            int contestantIndex = serializer.deserializeInt(buffer);
            return new RobotStatics(isJuniorRobot, isInteractiveRobot, isPaintRobot, isAdvancedRobot, isTeamRobot, isTeamLeader, isDroid, name, shortName, veryShortName, fullClassName, shortClassName, battleRules, teammates.toArray(new String[teammates.size()]), teamName, index, contestantIndex);
        }
    }
}

