/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.battle;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import robocode.control.RobotSpecification;

public class BattleProperties
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String BATTLEFIELD_WIDTH = "robocode.battleField.width";
    private static final String BATTLEFIELD_HEIGHT = "robocode.battleField.height";
    private static final String BATTLE_NUMROUNDS = "robocode.battle.numRounds";
    private static final String BATTLE_GUNCOOLINGRATE = "robocode.battle.gunCoolingRate";
    private static final String BATTLE_RULES_INACTIVITYTIME = "robocode.battle.rules.inactivityTime";
    private static final String BATTLE_SELECTEDROBOTS = "robocode.battle.selectedRobots";
    private static final String BATTLE_INITIAL_POSITIONS = "robocode.battle.initialPositions";
    private int battlefieldWidth = 800;
    private int battlefieldHeight = 600;
    private int numRounds = 10;
    private double gunCoolingRate = 0.1;
    private long inactivityTime = 450L;
    private String selectedRobots;
    private String initialPositions;
    private final Properties props = new Properties();

    public int getBattlefieldWidth() {
        return this.battlefieldWidth;
    }

    public void setBattlefieldWidth(int battlefieldWidth) {
        this.battlefieldWidth = battlefieldWidth;
        this.props.setProperty(BATTLEFIELD_WIDTH, "" + battlefieldWidth);
    }

    public int getBattlefieldHeight() {
        return this.battlefieldHeight;
    }

    public void setBattlefieldHeight(int battlefieldHeight) {
        this.battlefieldHeight = battlefieldHeight;
        this.props.setProperty(BATTLEFIELD_HEIGHT, "" + battlefieldHeight);
    }

    public int getNumRounds() {
        return this.numRounds;
    }

    public void setNumRounds(int numRounds) {
        this.numRounds = numRounds;
        this.props.setProperty(BATTLE_NUMROUNDS, "" + numRounds);
    }

    public double getGunCoolingRate() {
        return this.gunCoolingRate;
    }

    public void setGunCoolingRate(double gunCoolingRate) {
        this.gunCoolingRate = gunCoolingRate;
        this.props.setProperty(BATTLE_GUNCOOLINGRATE, "" + gunCoolingRate);
    }

    public long getInactivityTime() {
        return this.inactivityTime;
    }

    public void setInactivityTime(long inactivityTime) {
        this.inactivityTime = inactivityTime;
        this.props.setProperty(BATTLE_RULES_INACTIVITYTIME, "" + inactivityTime);
    }

    public String getSelectedRobots() {
        return this.selectedRobots;
    }

    public void setSelectedRobots(String selectedRobots) {
        this.selectedRobots = selectedRobots;
        this.props.setProperty(BATTLE_SELECTEDROBOTS, "" + selectedRobots);
    }

    public void setSelectedRobots(RobotSpecification[] robots) {
        StringBuffer robotString = new StringBuffer();
        for (int i = 0; i < robots.length; ++i) {
            RobotSpecification robot = robots[i];
            if (robot == null) continue;
            robotString.append(robot.getClassName());
            if (robot.getVersion() != null && robot.getVersion().length() != 0) {
                robotString.append(' ').append(robot.getVersion());
            }
            if (i >= robots.length - 1) continue;
            robotString.append(',');
        }
        this.setSelectedRobots(robotString.toString());
    }

    public String getInitialPositions() {
        return this.initialPositions;
    }

    public void setInitialPositions(String initialPositions) {
        this.initialPositions = initialPositions;
    }

    public void store(FileOutputStream out, String desc) throws IOException {
        this.props.store(out, desc);
    }

    public void load(FileInputStream in) throws IOException {
        this.props.load(in);
        this.battlefieldWidth = Integer.parseInt(this.props.getProperty(BATTLEFIELD_WIDTH, "800"));
        this.battlefieldHeight = Integer.parseInt(this.props.getProperty(BATTLEFIELD_HEIGHT, "600"));
        this.gunCoolingRate = Double.parseDouble(this.props.getProperty(BATTLE_GUNCOOLINGRATE, "0.1"));
        this.inactivityTime = Long.parseLong(this.props.getProperty(BATTLE_RULES_INACTIVITYTIME, "450"));
        this.numRounds = Integer.parseInt(this.props.getProperty(BATTLE_NUMROUNDS, "10"));
        this.selectedRobots = this.props.getProperty(BATTLE_SELECTEDROBOTS, "");
        this.initialPositions = this.props.getProperty(BATTLE_INITIAL_POSITIONS, "");
    }
}

