/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.recording;

import java.util.List;
import net.sf.robocode.battle.BaseBattle;
import net.sf.robocode.battle.IBattleManager;
import net.sf.robocode.battle.events.BattleEventDispatcher;
import net.sf.robocode.battle.snapshot.RobotSnapshot;
import net.sf.robocode.recording.RecordManager;
import net.sf.robocode.settings.ISettingsManager;
import robocode.BattleResults;
import robocode.control.events.BattleCompletedEvent;
import robocode.control.events.BattleFinishedEvent;
import robocode.control.events.BattlePausedEvent;
import robocode.control.events.BattleStartedEvent;
import robocode.control.events.RoundEndedEvent;
import robocode.control.events.RoundStartedEvent;
import robocode.control.events.TurnEndedEvent;
import robocode.control.events.TurnStartedEvent;
import robocode.control.snapshot.IRobotSnapshot;
import robocode.control.snapshot.ITurnSnapshot;

public final class BattlePlayer
extends BaseBattle {
    private final RecordManager recordManager;
    private boolean[] paint;

    public BattlePlayer(ISettingsManager properties, IBattleManager battleManager, RecordManager recordManager, BattleEventDispatcher eventDispatcher) {
        super(properties, battleManager, eventDispatcher);
        this.recordManager = recordManager;
        recordManager.prepareInputStream();
    }

    protected void initializeBattle() {
        super.initializeBattle();
        this.battleRules = this.recordManager.recordInfo.battleRules;
        this.paint = new boolean[this.recordManager.recordInfo.robotCount];
        this.eventDispatcher.onBattleStarted(new BattleStartedEvent(this.battleRules, this.recordManager.recordInfo.robotCount, true));
        if (this.isPaused()) {
            this.eventDispatcher.onBattlePaused(new BattlePausedEvent());
        }
    }

    protected void finalizeBattle() {
        boolean aborted = this.recordManager.recordInfo.results == null || this.isAborted();
        this.eventDispatcher.onBattleFinished(new BattleFinishedEvent(aborted));
        if (!aborted) {
            List<BattleResults> res = this.recordManager.recordInfo.results;
            this.eventDispatcher.onBattleCompleted(new BattleCompletedEvent(this.battleRules, res.toArray(new BattleResults[res.size()])));
        }
        super.finalizeBattle();
        this.cleanup();
    }

    protected void initializeRound() {
        super.initializeRound();
        ITurnSnapshot snapshot = this.recordManager.readSnapshot(this.currentTime);
        if (snapshot != null) {
            this.eventDispatcher.onRoundStarted(new RoundStartedEvent(snapshot, this.getRoundNum()));
        }
    }

    protected void finalizeRound() {
        super.finalizeRound();
        this.eventDispatcher.onRoundEnded(new RoundEndedEvent(this.getRoundNum(), this.getTime(), this.totalTurns));
    }

    protected void initializeTurn() {
        super.initializeTurn();
        this.eventDispatcher.onTurnStarted(new TurnStartedEvent());
    }

    protected void finalizeTurn() {
        ITurnSnapshot snapshot = this.recordManager.readSnapshot(this.currentTime);
        if (snapshot != null) {
            IRobotSnapshot[] robots = snapshot.getRobots();
            for (int i = 0; i < robots.length; ++i) {
                RobotSnapshot robot = (RobotSnapshot)robots[i];
                robot.setPaintEnabled(this.paint[i]);
            }
            this.eventDispatcher.onTurnEnded(new TurnEndedEvent(snapshot));
        }
        super.finalizeTurn();
    }

    protected boolean isRoundOver() {
        boolean end;
        boolean bl = end = this.getTime() >= this.recordManager.recordInfo.turnsInRounds[this.getRoundNum()] - 1;
        if (end && this.recordManager.recordInfo.turnsInRounds.length > this.getRoundNum() && this.recordManager.recordInfo.turnsInRounds[this.getRoundNum()] == 0) {
            this.isAborted = true;
        }
        return this.isAborted || end;
    }

    public void setPaintEnabled(int robotIndex, boolean enable) {
        this.sendCommand(new EnableRobotPaintCommand(robotIndex, enable));
    }

    private class EnableRobotPaintCommand
    extends BaseBattle.RobotCommand {
        final boolean enablePaint;

        EnableRobotPaintCommand(int robotIndex, boolean enablePaint) {
            super(robotIndex);
            this.enablePaint = enablePaint;
        }

        public void execute() {
            ((BattlePlayer)BattlePlayer.this).paint[this.robotIndex] = this.enablePaint;
        }
    }
}

