/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.battle.snapshot;

import java.io.IOException;
import java.io.Serializable;
import java.util.Dictionary;
import net.sf.robocode.battle.peer.RobotStatistics;
import net.sf.robocode.serialization.IXmlSerializable;
import net.sf.robocode.serialization.XmlReader;
import net.sf.robocode.serialization.XmlWriter;
import robocode.control.snapshot.IScoreSnapshot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ScoreSnapshot
implements Comparable<IScoreSnapshot>,
Serializable,
IXmlSerializable,
IScoreSnapshot {
    private static final long serialVersionUID = 1L;
    private String name;
    private double totalScore;
    private double totalSurvivalScore;
    private double totalLastSurvivorBonus;
    private double totalBulletDamageScore;
    private double totalBulletKillBonus;
    private double totalRammingDamageScore;
    private double totalRammingKillBonus;
    private int totalFirsts;
    private int totalSeconds;
    private int totalThirds;
    private double currentScore;
    private double currentSurvivalScore;
    private double currentSurvivalBonus;
    private double currentBulletDamageScore;
    private double currentBulletKillBonus;
    private double currentRammingDamageScore;
    private double currentRammingKillBonus;

    public ScoreSnapshot() {
    }

    public ScoreSnapshot(String contestantName, RobotStatistics score) {
        this.name = contestantName;
        this.totalScore = score.getTotalScore();
        this.totalSurvivalScore = score.getTotalSurvivalScore();
        this.totalLastSurvivorBonus = score.getTotalLastSurvivorBonus();
        this.totalBulletDamageScore = score.getTotalBulletDamageScore();
        this.totalBulletKillBonus = score.getTotalBulletKillBonus();
        this.totalRammingDamageScore = score.getTotalRammingDamageScore();
        this.totalRammingKillBonus = score.getTotalRammingKillBonus();
        this.totalFirsts = score.getTotalFirsts();
        this.totalSeconds = score.getTotalSeconds();
        this.totalThirds = score.getTotalThirds();
        this.currentScore = score.getCurrentScore();
        this.currentBulletDamageScore = score.getCurrentBulletDamageScore();
        this.currentSurvivalScore = score.getCurrentSurvivalScore();
        this.currentSurvivalBonus = score.getCurrentSurvivalBonus();
        this.currentBulletKillBonus = score.getCurrentBulletKillBonus();
        this.currentRammingDamageScore = score.getCurrentRammingDamageScore();
        this.currentRammingKillBonus = score.getCurrentRammingKillBonus();
    }

    public ScoreSnapshot(String contestantName, IScoreSnapshot score1, IScoreSnapshot score2) {
        this.name = contestantName;
        this.totalScore = score1.getTotalScore() + score2.getTotalScore();
        this.totalSurvivalScore = score1.getTotalSurvivalScore() + score2.getTotalSurvivalScore();
        this.totalLastSurvivorBonus = score1.getTotalLastSurvivorBonus() + score2.getTotalLastSurvivorBonus();
        this.totalBulletDamageScore = score1.getTotalBulletDamageScore() + score2.getTotalBulletDamageScore();
        this.totalBulletKillBonus = score1.getTotalBulletKillBonus() + score2.getTotalBulletKillBonus();
        this.totalRammingDamageScore = score1.getTotalRammingDamageScore() + score2.getTotalRammingDamageScore();
        this.totalRammingKillBonus = score1.getTotalRammingKillBonus() + score2.getTotalRammingKillBonus();
        this.totalFirsts = score1.getTotalFirsts() + score2.getTotalFirsts();
        this.totalSeconds = score1.getTotalSeconds() + score2.getTotalSeconds();
        this.totalThirds = score1.getTotalThirds() + score2.getTotalThirds();
        this.currentScore = score1.getCurrentScore() + score2.getCurrentScore();
        this.currentSurvivalScore = score1.getCurrentSurvivalScore() + score2.getCurrentSurvivalScore();
        this.currentBulletDamageScore = score1.getCurrentBulletDamageScore() + score2.getCurrentBulletDamageScore();
        this.currentBulletKillBonus = score1.getCurrentBulletKillBonus() + score2.getCurrentBulletKillBonus();
        this.currentRammingDamageScore = score1.getCurrentRammingDamageScore() + score2.getCurrentRammingDamageScore();
        this.currentRammingKillBonus = score1.getCurrentBulletKillBonus() + score2.getCurrentBulletKillBonus();
    }

    public String getName() {
        return this.name;
    }

    public double getTotalScore() {
        return this.totalScore;
    }

    public double getTotalSurvivalScore() {
        return this.totalSurvivalScore;
    }

    public double getTotalLastSurvivorBonus() {
        return this.totalLastSurvivorBonus;
    }

    public double getTotalBulletDamageScore() {
        return this.totalBulletDamageScore;
    }

    public double getTotalBulletKillBonus() {
        return this.totalBulletKillBonus;
    }

    public double getTotalRammingDamageScore() {
        return this.totalRammingDamageScore;
    }

    public double getTotalRammingKillBonus() {
        return this.totalRammingKillBonus;
    }

    public int getTotalFirsts() {
        return this.totalFirsts;
    }

    public int getTotalSeconds() {
        return this.totalSeconds;
    }

    public int getTotalThirds() {
        return this.totalThirds;
    }

    public double getCurrentScore() {
        return this.currentScore;
    }

    public double getCurrentSurvivalScore() {
        return this.currentSurvivalScore;
    }

    public double getCurrentSurvivalBonus() {
        return this.currentSurvivalBonus;
    }

    public double getCurrentBulletDamageScore() {
        return this.currentBulletDamageScore;
    }

    public double getCurrentBulletKillBonus() {
        return this.currentBulletKillBonus;
    }

    public double getCurrentRammingDamageScore() {
        return this.currentRammingDamageScore;
    }

    public double getCurrentRammingKillBonus() {
        return this.currentRammingKillBonus;
    }

    @Override
    public int compareTo(IScoreSnapshot o) {
        double myScore = this.getTotalScore();
        double hisScore = o.getTotalScore();
        if ((myScore += this.getCurrentScore()) < (hisScore += o.getCurrentScore())) {
            return -1;
        }
        if (myScore > hisScore) {
            return 1;
        }
        return 0;
    }

    public void writeXml(XmlWriter writer, Dictionary<String, Object> options) throws IOException {
        writer.startElement("score");
        writer.writeAttribute("name", this.name);
        writer.writeAttribute("totalScore", this.totalScore);
        writer.writeAttribute("totalSurvivalScore", this.totalSurvivalScore);
        writer.writeAttribute("totalLastSurvivorBonus", this.totalLastSurvivorBonus);
        writer.writeAttribute("totalBulletDamageScore", this.totalBulletDamageScore);
        writer.writeAttribute("totalBulletKillBonus", this.totalBulletKillBonus);
        writer.writeAttribute("totalRammingDamageScore", this.totalRammingDamageScore);
        writer.writeAttribute("totalRammingKillBonus", this.totalRammingKillBonus);
        writer.writeAttribute("totalFirsts", (long)this.totalFirsts);
        writer.writeAttribute("totalSeconds", (long)this.totalSeconds);
        writer.writeAttribute("totalThirds", (long)this.totalThirds);
        writer.writeAttribute("currentScore", this.currentScore);
        writer.writeAttribute("currentSurvivalScore", this.currentSurvivalScore);
        writer.writeAttribute("currentBulletDamageScore", this.currentBulletDamageScore);
        writer.writeAttribute("currentBulletKillBonus", this.currentBulletKillBonus);
        writer.writeAttribute("currentRammingDamageScore", this.currentRammingDamageScore);
        writer.writeAttribute("currentRammingKillBonus", this.currentRammingKillBonus);
        writer.writeAttribute("ver", 1L);
        writer.endElement();
    }

    public XmlReader.Element readXml(XmlReader reader) {
        return reader.expect("score", new XmlReader.Element(){

            public IXmlSerializable read(XmlReader reader) {
                final ScoreSnapshot snapshot = new ScoreSnapshot();
                reader.expect("name", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.name = value;
                    }
                });
                reader.expect("totalScore", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.totalScore = Double.parseDouble(value);
                    }
                });
                reader.expect("totalSurvivalScore", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.totalSurvivalScore = Double.parseDouble(value);
                    }
                });
                reader.expect("totalLastSurvivorBonus", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.totalLastSurvivorBonus = Double.parseDouble(value);
                    }
                });
                reader.expect("totalBulletDamageScore", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.totalBulletDamageScore = Double.parseDouble(value);
                    }
                });
                reader.expect("totalBulletKillBonus", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.totalBulletKillBonus = Double.parseDouble(value);
                    }
                });
                reader.expect("totalRammingDamageScore", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.totalRammingDamageScore = Double.parseDouble(value);
                    }
                });
                reader.expect("totalRammingKillBonus", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.totalRammingKillBonus = Double.parseDouble(value);
                    }
                });
                reader.expect("totalFirsts", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.totalFirsts = Integer.parseInt(value);
                    }
                });
                reader.expect("totalSeconds", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.totalSeconds = Integer.parseInt(value);
                    }
                });
                reader.expect("totalThirds", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.totalThirds = Integer.parseInt(value);
                    }
                });
                reader.expect("currentScore", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.currentScore = Double.parseDouble(value);
                    }
                });
                reader.expect("currentSurvivalScore", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.currentSurvivalScore = Double.parseDouble(value);
                    }
                });
                reader.expect("currentBulletDamageScore", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.currentBulletDamageScore = Double.parseDouble(value);
                    }
                });
                reader.expect("currentBulletKillBonus", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.currentBulletKillBonus = Double.parseDouble(value);
                    }
                });
                reader.expect("currentRammingDamageScore", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.currentRammingDamageScore = Double.parseDouble(value);
                    }
                });
                reader.expect("currentRammingKillBonus", new XmlReader.Attribute(){

                    public void read(String value) {
                        snapshot.currentRammingKillBonus = Double.parseDouble(value);
                    }
                });
                return snapshot;
            }
        });
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.currentBulletDamageScore);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.currentBulletKillBonus);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.currentRammingDamageScore);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.currentRammingKillBonus);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.currentScore);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.currentSurvivalBonus);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.currentSurvivalScore);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        temp = Double.doubleToLongBits(this.totalBulletDamageScore);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.totalBulletKillBonus);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.totalFirsts;
        temp = Double.doubleToLongBits(this.totalLastSurvivorBonus);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.totalRammingDamageScore);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.totalRammingKillBonus);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.totalScore);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.totalSeconds;
        temp = Double.doubleToLongBits(this.totalSurvivalScore);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.totalThirds;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScoreSnapshot other = (ScoreSnapshot)obj;
        if (Double.doubleToLongBits(this.currentBulletDamageScore) != Double.doubleToLongBits(other.currentBulletDamageScore)) {
            return false;
        }
        if (Double.doubleToLongBits(this.currentBulletKillBonus) != Double.doubleToLongBits(other.currentBulletKillBonus)) {
            return false;
        }
        if (Double.doubleToLongBits(this.currentRammingDamageScore) != Double.doubleToLongBits(other.currentRammingDamageScore)) {
            return false;
        }
        if (Double.doubleToLongBits(this.currentRammingKillBonus) != Double.doubleToLongBits(other.currentRammingKillBonus)) {
            return false;
        }
        if (Double.doubleToLongBits(this.currentScore) != Double.doubleToLongBits(other.currentScore)) {
            return false;
        }
        if (Double.doubleToLongBits(this.currentSurvivalBonus) != Double.doubleToLongBits(other.currentSurvivalBonus)) {
            return false;
        }
        if (Double.doubleToLongBits(this.currentSurvivalScore) != Double.doubleToLongBits(other.currentSurvivalScore)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (Double.doubleToLongBits(this.totalBulletDamageScore) != Double.doubleToLongBits(other.totalBulletDamageScore)) {
            return false;
        }
        if (Double.doubleToLongBits(this.totalBulletKillBonus) != Double.doubleToLongBits(other.totalBulletKillBonus)) {
            return false;
        }
        if (this.totalFirsts != other.totalFirsts) {
            return false;
        }
        if (Double.doubleToLongBits(this.totalLastSurvivorBonus) != Double.doubleToLongBits(other.totalLastSurvivorBonus)) {
            return false;
        }
        if (Double.doubleToLongBits(this.totalRammingDamageScore) != Double.doubleToLongBits(other.totalRammingDamageScore)) {
            return false;
        }
        if (Double.doubleToLongBits(this.totalRammingKillBonus) != Double.doubleToLongBits(other.totalRammingKillBonus)) {
            return false;
        }
        if (Double.doubleToLongBits(this.totalScore) != Double.doubleToLongBits(other.totalScore)) {
            return false;
        }
        if (this.totalSeconds != other.totalSeconds) {
            return false;
        }
        if (Double.doubleToLongBits(this.totalSurvivalScore) != Double.doubleToLongBits(other.totalSurvivalScore)) {
            return false;
        }
        return this.totalThirds == other.totalThirds;
    }
}

