/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.battle.peer;

import java.util.ArrayList;
import java.util.List;
import net.sf.robocode.battle.peer.ContestantPeer;
import net.sf.robocode.battle.peer.ContestantStatistics;
import net.sf.robocode.battle.peer.RobotPeer;
import net.sf.robocode.battle.peer.TeamStatistics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeamPeer
extends ArrayList<RobotPeer>
implements ContestantPeer {
    private final List<String> memberNames;
    private final String name;
    private final int contestIndex;
    private RobotPeer teamLeader;
    private final TeamStatistics teamStatistics;

    public TeamPeer(String name, List<String> memberNames, int contestIndex) {
        this.name = name;
        this.contestIndex = contestIndex;
        this.memberNames = memberNames;
        this.teamStatistics = new TeamStatistics(this);
    }

    @Override
    public int compareTo(ContestantPeer cp) {
        double myScore = this.teamStatistics.getTotalScore();
        double hisScore = cp.getStatistics().getTotalScore();
        if (this.teamLeader != null && this.teamLeader.getRobotStatistics().isInRound()) {
            myScore += this.teamStatistics.getCurrentScore();
            hisScore += cp.getStatistics().getCurrentScore();
        }
        if (myScore < hisScore) {
            return -1;
        }
        if (myScore > hisScore) {
            return 1;
        }
        return 0;
    }

    @Override
    public ContestantStatistics getStatistics() {
        return this.teamStatistics;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getContestIndex() {
        return this.contestIndex;
    }

    public List<String> getMemberNames() {
        return this.memberNames;
    }

    public RobotPeer getTeamLeader() {
        return this.teamLeader;
    }

    @Override
    public boolean add(RobotPeer r) {
        if (this.teamLeader == null) {
            this.teamLeader = r;
        }
        return super.add(r);
    }

    @Override
    public String toString() {
        return " [" + this.size() + "] " + this.getName();
    }
}

