/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.monitors;

import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.injectors.AbstractInjector;
import org.picocontainer.monitors.ComponentMonitorHelper;
import org.picocontainer.monitors.NullComponentMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WriterComponentMonitor
implements ComponentMonitor {
    private final PrintWriter out;
    private final ComponentMonitor delegate;

    public WriterComponentMonitor(Writer out) {
        this(out, new NullComponentMonitor());
    }

    public WriterComponentMonitor(Writer out, ComponentMonitor delegate) {
        this.out = new PrintWriter(out);
        this.delegate = delegate;
    }

    @Override
    public <T> Constructor<T> instantiating(PicoContainer container, ComponentAdapter<T> componentAdapter, Constructor<T> constructor) {
        this.out.println(ComponentMonitorHelper.format("PicoContainer: instantiating {0}", ComponentMonitorHelper.ctorToString(constructor)));
        return this.delegate.instantiating(container, componentAdapter, constructor);
    }

    @Override
    public <T> void instantiated(PicoContainer container, ComponentAdapter<T> componentAdapter, Constructor<T> constructor, Object instantiated, Object[] injected, long duration) {
        this.out.println(ComponentMonitorHelper.format("PicoContainer: instantiated {0} [{1} ms], component {2}, injected [{3}]", ComponentMonitorHelper.ctorToString(constructor), duration, instantiated.getClass().getName(), ComponentMonitorHelper.parmsToString(injected)));
        this.delegate.instantiated(container, componentAdapter, constructor, instantiated, injected, duration);
    }

    @Override
    public <T> void instantiationFailed(PicoContainer container, ComponentAdapter<T> componentAdapter, Constructor<T> constructor, Exception cause) {
        this.out.println(ComponentMonitorHelper.format("PicoContainer: instantiation failed: {0}, reason: {1}", ComponentMonitorHelper.ctorToString(constructor), cause.getMessage()));
        this.delegate.instantiationFailed(container, null, constructor, cause);
    }

    @Override
    public void invoking(PicoContainer container, ComponentAdapter<?> componentAdapter, Member member, Object instance) {
        this.out.println(ComponentMonitorHelper.format("PicoContainer: invoking {0} on {1}", ComponentMonitorHelper.memberToString(member), instance));
        this.delegate.invoking(container, componentAdapter, member, instance);
    }

    @Override
    public void invoked(PicoContainer container, ComponentAdapter<?> componentAdapter, Method method, Object instance, long duration) {
        this.out.println(ComponentMonitorHelper.format("PicoContainer: invoked {0} on {1} [{2} ms]", ComponentMonitorHelper.methodToString(method), instance, duration));
        this.delegate.invoked(container, componentAdapter, method, instance, duration);
    }

    @Override
    public void invocationFailed(Member member, Object instance, Exception cause) {
        this.out.println(ComponentMonitorHelper.format("PicoContainer: invocation failed: {0} on {1}, reason: {2}", ComponentMonitorHelper.memberToString(member), instance, cause.getMessage()));
        this.delegate.invocationFailed(member, instance, cause);
    }

    @Override
    public void lifecycleInvocationFailed(MutablePicoContainer container, ComponentAdapter<?> componentAdapter, Method method, Object instance, RuntimeException cause) {
        this.out.println(ComponentMonitorHelper.format("PicoContainer: lifecycle invocation failed: {0} on {1}, reason: {2}", ComponentMonitorHelper.methodToString(method), instance, cause.getMessage()));
        this.delegate.lifecycleInvocationFailed(container, componentAdapter, method, instance, cause);
    }

    @Override
    public Object noComponentFound(MutablePicoContainer container, Object componentKey) {
        this.out.println(ComponentMonitorHelper.format("PicoContainer: No component for key: {0}", componentKey));
        return this.delegate.noComponentFound(container, componentKey);
    }

    @Override
    public AbstractInjector newInjectionFactory(AbstractInjector abstractInjector) {
        return this.delegate.newInjectionFactory(abstractInjector);
    }
}

