/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.monitors;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoException;
import org.picocontainer.PicoLifecycleException;
import org.picocontainer.injectors.AbstractInjector;
import org.picocontainer.monitors.NullComponentMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LifecycleComponentMonitor
implements ComponentMonitor {
    private final ComponentMonitor delegate;
    private final List<RuntimeException> lifecycleFailures = new ArrayList<RuntimeException>();

    public LifecycleComponentMonitor(ComponentMonitor delegate) {
        this.delegate = delegate;
    }

    public LifecycleComponentMonitor() {
        this(new NullComponentMonitor());
    }

    @Override
    public <T> Constructor<T> instantiating(PicoContainer container, ComponentAdapter<T> componentAdapter, Constructor<T> constructor) {
        return this.delegate.instantiating(container, componentAdapter, constructor);
    }

    @Override
    public <T> void instantiated(PicoContainer container, ComponentAdapter<T> componentAdapter, Constructor<T> constructor, Object instantiated, Object[] parameters, long duration) {
        this.delegate.instantiated(container, componentAdapter, constructor, instantiated, parameters, duration);
    }

    @Override
    public <T> void instantiationFailed(PicoContainer container, ComponentAdapter<T> componentAdapter, Constructor<T> constructor, Exception cause) {
        this.delegate.instantiationFailed(container, componentAdapter, constructor, cause);
    }

    @Override
    public void invoking(PicoContainer container, ComponentAdapter<?> componentAdapter, Member member, Object instance) {
        this.delegate.invoking(container, componentAdapter, member, instance);
    }

    @Override
    public void invoked(PicoContainer container, ComponentAdapter<?> componentAdapter, Method method, Object instance, long duration) {
        this.delegate.invoked(container, componentAdapter, method, instance, duration);
    }

    @Override
    public void invocationFailed(Member member, Object instance, Exception cause) {
        this.delegate.invocationFailed(member, instance, cause);
    }

    @Override
    public void lifecycleInvocationFailed(MutablePicoContainer container, ComponentAdapter<?> componentAdapter, Method method, Object instance, RuntimeException cause) {
        this.lifecycleFailures.add(cause);
        try {
            this.delegate.lifecycleInvocationFailed(container, componentAdapter, method, instance, cause);
        }
        catch (PicoLifecycleException e) {
            // empty catch block
        }
    }

    @Override
    public Object noComponentFound(MutablePicoContainer container, Object componentKey) {
        return this.delegate.noComponentFound(container, componentKey);
    }

    @Override
    public AbstractInjector newInjectionFactory(AbstractInjector abstractInjector) {
        return this.delegate.newInjectionFactory(abstractInjector);
    }

    public void rethrowLifecycleFailuresException() {
        throw new LifecycleFailuresException(this.lifecycleFailures);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class LifecycleFailuresException
    extends PicoException {
        private final List<RuntimeException> lifecycleFailures;

        public LifecycleFailuresException(List<RuntimeException> lifecycleFailures) {
            this.lifecycleFailures = lifecycleFailures;
        }

        @Override
        public String getMessage() {
            StringBuffer message = new StringBuffer();
            for (RuntimeException lifecycleFailure : this.lifecycleFailures) {
                Exception failure = lifecycleFailure;
                message.append(failure.getMessage()).append(";  ");
            }
            return message.toString();
        }

        public Collection<RuntimeException> getFailures() {
            return this.lifecycleFailures;
        }
    }
}

