/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.lifecycle;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.Disposable;
import org.picocontainer.PicoLifecycleException;
import org.picocontainer.Startable;
import org.picocontainer.lifecycle.AbstractMonitoringLifecycleStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartableLifecycleStrategy
extends AbstractMonitoringLifecycleStrategy {
    private transient Method start;
    private transient Method stop;
    private transient Method dispose;

    public StartableLifecycleStrategy(ComponentMonitor monitor) {
        super(monitor);
    }

    private void doMethodsIfNotDone() {
        try {
            if (this.start == null) {
                this.start = this.getStartableInterface().getMethod(this.getStartMethodName(), new Class[0]);
            }
            if (this.stop == null) {
                this.stop = this.getStartableInterface().getMethod(this.getStopMethodName(), new Class[0]);
            }
            if (this.dispose == null) {
                this.dispose = this.getDisposableInterface().getMethod(this.getDisposeMethodName(), new Class[0]);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    protected String getDisposeMethodName() {
        return "dispose";
    }

    protected String getStopMethodName() {
        return "stop";
    }

    protected String getStartMethodName() {
        return "start";
    }

    @Override
    public void start(Object component) {
        this.doMethodsIfNotDone();
        if (component != null && this.getStartableInterface().isAssignableFrom(component.getClass())) {
            long str = System.currentTimeMillis();
            this.currentMonitor().invoking(null, null, this.start, component);
            try {
                this.startComponent(component);
                this.currentMonitor().invoked(null, null, this.start, component, System.currentTimeMillis() - str);
            }
            catch (RuntimeException cause) {
                this.currentMonitor().lifecycleInvocationFailed(null, null, this.start, component, cause);
            }
        }
    }

    protected void startComponent(Object component) {
        this.doLifecycleMethod(component, this.start);
    }

    private void doLifecycleMethod(Object component, Method lifecycleMethod) {
        try {
            lifecycleMethod.invoke(component, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new PicoLifecycleException(lifecycleMethod, component, e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new PicoLifecycleException(lifecycleMethod, component, e.getTargetException());
        }
    }

    protected void stopComponent(Object component) {
        this.doLifecycleMethod(component, this.stop);
    }

    protected void disposeComponent(Object component) {
        this.doLifecycleMethod(component, this.dispose);
    }

    @Override
    public void stop(Object component) {
        this.doMethodsIfNotDone();
        if (component != null && this.getStartableInterface().isAssignableFrom(component.getClass())) {
            long str = System.currentTimeMillis();
            this.currentMonitor().invoking(null, null, this.stop, component);
            try {
                this.stopComponent(component);
                this.currentMonitor().invoked(null, null, this.stop, component, System.currentTimeMillis() - str);
            }
            catch (RuntimeException cause) {
                this.currentMonitor().lifecycleInvocationFailed(null, null, this.stop, component, cause);
            }
        }
    }

    @Override
    public void dispose(Object component) {
        this.doMethodsIfNotDone();
        if (component != null && this.getDisposableInterface().isAssignableFrom(component.getClass())) {
            long str = System.currentTimeMillis();
            this.currentMonitor().invoking(null, null, this.dispose, component);
            try {
                this.disposeComponent(component);
                this.currentMonitor().invoked(null, null, this.dispose, component, System.currentTimeMillis() - str);
            }
            catch (RuntimeException cause) {
                this.currentMonitor().lifecycleInvocationFailed(null, null, this.dispose, component, cause);
            }
        }
    }

    @Override
    public boolean hasLifecycle(Class<?> type) {
        return this.getStartableInterface().isAssignableFrom(type) || this.getDisposableInterface().isAssignableFrom(type);
    }

    protected Class getDisposableInterface() {
        return Disposable.class;
    }

    protected Class getStartableInterface() {
        return Startable.class;
    }
}

