/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.injectors;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.Parameter;
import org.picocontainer.injectors.AbstractInjector;
import org.picocontainer.injectors.IterativeInjector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetterInjector<T>
extends IterativeInjector<T> {
    private final String setterMethodPrefix;

    public SetterInjector(Object componentKey, Class componentImplementation, Parameter[] parameters, ComponentMonitor monitor, LifecycleStrategy lifecycleStrategy, String setterMethodPrefix, boolean useNames) throws AbstractInjector.NotConcreteRegistrationException {
        super(componentKey, componentImplementation, parameters, monitor, lifecycleStrategy, useNames);
        this.setterMethodPrefix = setterMethodPrefix;
    }

    @Override
    protected void injectIntoMember(AccessibleObject member, Object componentInstance, Object toInject) throws IllegalAccessException, InvocationTargetException {
        ((Method)member).invoke(componentInstance, toInject);
    }

    @Override
    protected boolean isInjectorMethod(Method method) {
        String methodName = method.getName();
        return methodName.length() >= this.getInjectorPrefix().length() + 1 && methodName.startsWith(this.getInjectorPrefix()) && Character.isUpperCase(methodName.charAt(this.getInjectorPrefix().length()));
    }

    protected String getInjectorPrefix() {
        return this.setterMethodPrefix;
    }

    @Override
    public String getDescriptor() {
        return "SetterInjector-";
    }
}

