/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.behaviors;

import java.lang.reflect.Type;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.ObjectReference;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.behaviors.AbstractBehavior;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stored<T>
extends AbstractBehavior<T> {
    protected final boolean delegateHasLifecylce;
    protected boolean disposed;
    protected final ObjectReference<T> instanceReference;
    protected boolean started;

    public Stored(ComponentAdapter<T> delegate, ObjectReference<T> reference) {
        super(delegate);
        this.instanceReference = reference;
        this.disposed = false;
        this.started = false;
        this.delegateHasLifecylce = delegate instanceof LifecycleStrategy && ((LifecycleStrategy)((Object)delegate)).hasLifecycle(delegate.getComponentImplementation());
    }

    @Override
    public boolean componentHasLifecycle() {
        return this.delegateHasLifecylce;
    }

    @Override
    public void dispose(PicoContainer container) {
        if (this.delegateHasLifecylce) {
            if (this.disposed) {
                throw new IllegalStateException("Already disposed");
            }
            this.dispose(this.getComponentInstance(container, (Type)((Object)ComponentAdapter.NOTHING.class)));
            this.disposed = true;
        }
    }

    public T getStoredObject() {
        return this.instanceReference.get();
    }

    public void flush() {
        T instance = this.instanceReference.get();
        if (instance != null && this.delegateHasLifecylce && this.started) {
            this.stop(instance);
            this.dispose(instance);
        }
        this.instanceReference.set(null);
    }

    @Override
    public T getComponentInstance(PicoContainer container, Type into) throws PicoCompositionException {
        T instance = this.instanceReference.get();
        if (instance == null) {
            instance = super.getComponentInstance(container, into);
            this.instanceReference.set(instance);
        }
        return instance;
    }

    @Override
    public String getDescriptor() {
        return "Stored";
    }

    @Override
    public void start(PicoContainer container) {
        if (this.delegateHasLifecylce) {
            if (this.disposed) {
                throw new IllegalStateException("Already disposed");
            }
            if (this.started) {
                throw new IllegalStateException("Already started");
            }
            this.start(this.getComponentInstance(container, (Type)((Object)ComponentAdapter.NOTHING.class)));
            this.started = true;
        }
    }

    @Override
    public void stop(PicoContainer container) {
        if (this.delegateHasLifecylce) {
            if (this.disposed) {
                throw new IllegalStateException("Already disposed");
            }
            if (!this.started) {
                throw new IllegalStateException("Not started");
            }
            this.stop(this.getComponentInstance(container, (Type)((Object)ComponentAdapter.NOTHING.class)));
            this.started = false;
        }
    }
}

