/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.picocontainer.BehaviorFactory;
import org.picocontainer.ComponentFactory;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.DefaultPicoContainer;
import org.picocontainer.InjectionFactory;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.behaviors.Automating;
import org.picocontainer.behaviors.Behaviors;
import org.picocontainer.behaviors.Locking;
import org.picocontainer.behaviors.PropertyApplying;
import org.picocontainer.behaviors.Synchronizing;
import org.picocontainer.containers.EmptyPicoContainer;
import org.picocontainer.containers.TransientPicoContainer;
import org.picocontainer.injectors.Injectors;
import org.picocontainer.injectors.MethodInjection;
import org.picocontainer.lifecycle.NullLifecycleStrategy;
import org.picocontainer.lifecycle.ReflectionLifecycleStrategy;
import org.picocontainer.lifecycle.StartableLifecycleStrategy;
import org.picocontainer.monitors.ConsoleComponentMonitor;
import org.picocontainer.monitors.NullComponentMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PicoBuilder {
    private PicoContainer parentContainer;
    private Class<? extends MutablePicoContainer> mpcClass = DefaultPicoContainer.class;
    private ComponentMonitor componentMonitor;
    private List<Object> containerComps = new ArrayList<Object>();
    private boolean addChildToParent;
    private final Stack<Object> componentFactories = new Stack();
    private InjectionFactory injectionType;
    private Class<? extends ComponentMonitor> componentMonitorClass = NullComponentMonitor.class;
    private Class<? extends LifecycleStrategy> lifecycleStrategyClass = NullLifecycleStrategy.class;

    public PicoBuilder(PicoContainer parentContainer, InjectionFactory injectionType) {
        this.injectionType = injectionType;
        this.parentContainer = parentContainer != null ? parentContainer : new EmptyPicoContainer();
    }

    public PicoBuilder(PicoContainer parentContainer) {
        this(parentContainer, Injectors.adaptiveDI());
    }

    public PicoBuilder(InjectionFactory injectionType) {
        this(new EmptyPicoContainer(), injectionType);
    }

    public PicoBuilder() {
        this(new EmptyPicoContainer(), Injectors.adaptiveDI());
    }

    public PicoBuilder withLifecycle() {
        this.lifecycleStrategyClass = StartableLifecycleStrategy.class;
        return this;
    }

    public PicoBuilder withReflectionLifecycle() {
        this.lifecycleStrategyClass = ReflectionLifecycleStrategy.class;
        return this;
    }

    public PicoBuilder withConsoleMonitor() {
        this.componentMonitorClass = ConsoleComponentMonitor.class;
        return this;
    }

    public PicoBuilder withMonitor(Class<? extends ComponentMonitor> cmClass) {
        if (cmClass == null) {
            throw new NullPointerException("monitor class cannot be null");
        }
        if (!ComponentMonitor.class.isAssignableFrom(cmClass)) {
            throw new ClassCastException(cmClass.getName() + " is not a " + ComponentMonitor.class.getName());
        }
        this.componentMonitorClass = cmClass;
        this.componentMonitor = null;
        return this;
    }

    public MutablePicoContainer build() {
        TransientPicoContainer temp = new TransientPicoContainer();
        temp.addComponent(PicoContainer.class, this.parentContainer, new Parameter[0]);
        for (Object containerComp : this.containerComps) {
            temp.addComponent(containerComp);
        }
        ComponentFactory lastCaf = this.injectionType;
        while (!this.componentFactories.empty()) {
            Object componentFactory = this.componentFactories.pop();
            TransientPicoContainer temp2 = new TransientPicoContainer(temp);
            temp2.addComponent("componentFactory", componentFactory, new Parameter[0]);
            if (lastCaf != null) {
                temp2.addComponent(ComponentFactory.class, lastCaf, new Parameter[0]);
            }
            InjectionFactory penultimateCaf = lastCaf;
            lastCaf = (ComponentFactory)temp2.getComponent("componentFactory");
            if (!(lastCaf instanceof BehaviorFactory)) continue;
            ((BehaviorFactory)lastCaf).wrap(penultimateCaf);
        }
        temp.addComponent(ComponentFactory.class, lastCaf, new Parameter[0]);
        if (this.componentMonitorClass == null) {
            temp.addComponent(ComponentMonitor.class, this.componentMonitor, new Parameter[0]);
        } else {
            temp.addComponent(ComponentMonitor.class, this.componentMonitorClass, new Parameter[0]);
        }
        temp.addComponent(LifecycleStrategy.class, this.lifecycleStrategyClass, new Parameter[0]);
        temp.addComponent("mpc", this.mpcClass, new Parameter[0]);
        MutablePicoContainer newContainer = (MutablePicoContainer)temp.getComponent("mpc");
        if (this.addChildToParent) {
            if (this.parentContainer instanceof MutablePicoContainer) {
                ((MutablePicoContainer)this.parentContainer).addChildContainer(newContainer);
            } else {
                throw new PicoCompositionException("If using addChildContainer() the parent must be a MutablePicoContainer");
            }
        }
        return newContainer;
    }

    public PicoBuilder withHiddenImplementations() {
        this.componentFactories.push(Behaviors.implementationHiding());
        return this;
    }

    public PicoBuilder withSetterInjection() {
        this.injectionType = Injectors.SDI();
        return this;
    }

    public PicoBuilder withAnnotatedMethodInjection() {
        this.injectionType = Injectors.annotatedMethodDI();
        return this;
    }

    public PicoBuilder withAnnotatedFieldInjection() {
        this.injectionType = Injectors.annotatedFieldDI();
        return this;
    }

    public PicoBuilder withConstructorInjection() {
        this.injectionType = Injectors.CDI();
        return this;
    }

    public PicoBuilder withCaching() {
        this.componentFactories.push(Behaviors.caching());
        return this;
    }

    public PicoBuilder withComponentFactory(ComponentFactory componentFactory) {
        if (componentFactory == null) {
            throw new NullPointerException("CAF cannot be null");
        }
        this.componentFactories.push(componentFactory);
        return this;
    }

    public PicoBuilder withSynchronizing() {
        this.componentFactories.push(Synchronizing.class);
        return this;
    }

    public PicoBuilder withLocking() {
        this.componentFactories.push(Locking.class);
        return this;
    }

    public PicoBuilder withBehaviors(BehaviorFactory ... factories) {
        for (BehaviorFactory componentFactory : factories) {
            this.componentFactories.push(componentFactory);
        }
        return this;
    }

    public PicoBuilder implementedBy(Class<? extends MutablePicoContainer> containerClass) {
        this.mpcClass = containerClass;
        return this;
    }

    public PicoBuilder withMonitor(ComponentMonitor componentMonitor) {
        this.componentMonitor = componentMonitor;
        this.componentMonitorClass = null;
        return this;
    }

    public PicoBuilder withComponentFactory(Class<? extends ComponentFactory> componentFactoryClass) {
        this.componentFactories.push(componentFactoryClass);
        return this;
    }

    public PicoBuilder withCustomContainerComponent(Object containerDependency) {
        this.containerComps.add(containerDependency);
        return this;
    }

    public PicoBuilder withPropertyApplier() {
        this.componentFactories.push(PropertyApplying.class);
        return this;
    }

    public PicoBuilder withAutomatic() {
        this.componentFactories.push(Automating.class);
        return this;
    }

    public PicoBuilder withMethodInjection() {
        this.componentFactories.push(new MethodInjection());
        return this;
    }

    public PicoBuilder addChildToParent() {
        this.addChildToParent = true;
        return this;
    }
}

