/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.mqttbroker;

import io.moquette.server.Server;
import io.moquette.server.config.IConfig;
import java.io.IOException;
import org.mycontroller.standalone.ObjectFactory;
import org.mycontroller.standalone.mqttbroker.BrokerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoquetteMqttBroker {
    private static final Logger _logger = LoggerFactory.getLogger((String)MoquetteMqttBroker.class.getName());
    private static boolean isRunning = false;
    private static Server mqttServer = null;

    private MoquetteMqttBroker() {
    }

    public static synchronized void start() {
        if (!ObjectFactory.getAppProperties().isMqttBrokerEnabled()) {
            _logger.debug("InBuilt MQTT broker is not enabled... Skipping to start...");
            return;
        }
        if (isRunning) {
            _logger.info("MQTT Broker already running, nothing to do...");
            return;
        }
        try {
            mqttServer = new Server();
            mqttServer.startServer((IConfig)new BrokerConfiguration());
            isRunning = true;
            _logger.debug("MQTT Broker started successfully");
        }
        catch (IOException ex) {
            _logger.error("Unable to start MQTT Broker, Exception, ", (Throwable)ex);
        }
    }

    public static synchronized void stop() {
        if (!ObjectFactory.getAppProperties().isMqttBrokerEnabled()) {
            _logger.debug("InBuilt MQTT broker is not enabled... Skipping to stop...");
            return;
        }
        if (!isRunning) {
            _logger.info("MQTT Broker is not running, nothing to do...");
            return;
        }
        mqttServer.stopServer();
        mqttServer = null;
        isRunning = false;
        _logger.debug("MQTT Broker has been stopped successfully");
    }
}

