/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.jobs;

import com.xeiam.sundial.Job;
import com.xeiam.sundial.exceptions.JobInterruptException;
import java.util.List;
import org.mycontroller.standalone.AppProperties;
import org.mycontroller.standalone.ObjectFactory;
import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.db.tables.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeAliveStatusJob
extends Job {
    public static final String NAME = "node_alive_status_job";
    public static final String TRIGGER_NAME = "node_alive_status_trigger";
    private static final Logger _logger = LoggerFactory.getLogger(NodeAliveStatusJob.class);
    private static final long WAIT_TIME_TO_CHECK_ALIVE_STATUS = 30000L;
    public static final long DEFAULT_ALIVE_CHECK_INTERVAL = 1800000L;

    public void doRun() throws JobInterruptException {
        try {
            this.sendHearbeat();
            Thread.sleep(30000L);
            this.checkHearbeat();
        }
        catch (Exception ex) {
            _logger.error("Exception, ", (Throwable)ex);
        }
    }

    private void sendHearbeat() {
        List<Node> nodes = DaoUtils.getNodeDao().getAll();
        block3: for (Node node : nodes) {
            switch (node.getGateway().getNetworkType()) {
                case MY_SENSORS: {
                    ObjectFactory.getIActionEngine(AppProperties.NETWORK_TYPE.MY_SENSORS).sendAliveStatusRequest(node);
                    continue block3;
                }
            }
            return;
        }
    }

    private void checkHearbeat() {
        List<Node> nodes = DaoUtils.getNodeDao().getAll();
        long aliveCheckInterval = ObjectFactory.getAppProperties().getControllerSettings().getAliveCheckInterval();
        if (aliveCheckInterval < 60000L) {
            aliveCheckInterval = 60000L;
        }
        for (Node node : nodes) {
            if (node.getLastSeen() != null && node.getLastSeen() > System.currentTimeMillis() - aliveCheckInterval) continue;
            node.setState(AppProperties.STATE.DOWN);
            DaoUtils.getNodeDao().update(node);
            _logger.debug("Node is in not reachable state, Node:[{}]", (Object)node);
        }
    }
}

