/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.gateway.mqtt;

import org.apache.commons.lang.StringUtils;
import org.eclipse.paho.client.mqttv3.IMqttClient;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.mycontroller.standalone.AppProperties;
import org.mycontroller.standalone.ObjectFactory;
import org.mycontroller.standalone.gateway.GatewayMQTT;
import org.mycontroller.standalone.message.RawMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttCallbackListener
implements MqttCallback {
    private static final Logger _logger = LoggerFactory.getLogger((String)MqttCallbackListener.class.getName());
    private IMqttClient mqttClient;
    private GatewayMQTT gateway;
    private boolean reconnect = true;
    public static final long RECONNECT_WAIT_TIME = 5000L;

    public MqttCallbackListener(IMqttClient mqttClient, GatewayMQTT gateway) {
        this.mqttClient = mqttClient;
        this.gateway = gateway;
    }

    public void connectionLost(Throwable throwable) {
        _logger.error("MQTT Gateway[id:{}, Name:{}, serverURI:{}] connection lost! Error:{}", new Object[]{this.gateway.getId(), this.gateway.getName(), this.mqttClient.getServerURI(), throwable.getMessage()});
        this.gateway.setStatus(AppProperties.STATE.DOWN, "ERROR: Connection lost! [" + throwable.getMessage() + "]");
        this.gateway.updateGateway();
        while (this.isReconnect() && !this.mqttClient.isConnected()) {
            try {
                this.mqttClient.connect();
                _logger.info("MQTT Gateway[{}] Reconnected successfully...", (Object)this.mqttClient.getServerURI());
                this.gateway.setStatus(AppProperties.STATE.UP, "Reconnected successfully...");
                this.gateway.updateGateway();
            }
            catch (MqttException ex) {
                _logger.error("Exception, Reason Code:{}", (Object)ex.getReasonCode(), (Object)ex);
            }
            long waitTime = 5000L;
            while (waitTime > 0L && this.isReconnect()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    _logger.error("Exception, ", (Throwable)ex);
                }
            }
        }
    }

    public void deliveryComplete(IMqttDeliveryToken deliveryToken) {
        try {
            _logger.debug("Message Delivery Complete, [Message Id:{}, Topic:{}, PayLoad:{}]", new Object[]{deliveryToken.getMessageId(), StringUtils.join((Object[])deliveryToken.getTopics(), (String)","), deliveryToken.getMessage()});
        }
        catch (MqttException ex) {
            _logger.error("Exception, ", (Throwable)ex);
        }
    }

    public void messageArrived(String topic, MqttMessage message) {
        try {
            _logger.debug("Message Received, Topic:[{}], PayLoad:[{}]", (Object)topic, (Object)message);
            RawMessage rawMessage = new RawMessage(this.gateway.getId(), message.toString(), topic);
            ObjectFactory.getRawMessageQueue().putMessage(rawMessage);
        }
        catch (Exception ex) {
            _logger.error("Exception, ", (Throwable)ex);
        }
    }

    public boolean isReconnect() {
        return this.reconnect;
    }

    public synchronized void setReconnect(boolean reconnect) {
        this.reconnect = reconnect;
    }
}

