/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.gateway.ethernet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import org.mycontroller.standalone.ObjectFactory;
import org.mycontroller.standalone.gateway.GatewayEthernet;
import org.mycontroller.standalone.message.RawMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EthernetGatewayListener
implements Runnable {
    private static final Logger _logger = LoggerFactory.getLogger((String)EthernetGatewayListener.class.getName());
    private Socket socket = null;
    private boolean terminate = false;
    private boolean terminated = false;
    private GatewayEthernet gateway = null;

    public EthernetGatewayListener(Socket socket, GatewayEthernet gateway) {
        this.socket = socket;
        this.gateway = gateway;
    }

    @Override
    public void run() {
        BufferedReader buf = null;
        try {
            buf = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        }
        catch (IOException ex) {
            _logger.error("Exception, ", (Throwable)ex);
        }
        while (!this.isTerminate()) {
            try {
                if (buf.ready()) {
                    String message = buf.readLine();
                    _logger.debug("Message Received: {}", (Object)message);
                    ObjectFactory.getRawMessageQueue().putMessage(new RawMessage(this.gateway.getId(), message));
                }
                Thread.sleep(100L);
            }
            catch (IOException | InterruptedException ex) {
                _logger.error("Exception, ", (Throwable)ex);
            }
        }
        _logger.debug("EthernetGatewayListener Terminated...");
        this.terminated = true;
    }

    public boolean isTerminate() {
        return this.terminate;
    }

    public synchronized void setTerminate(boolean terminate) {
        this.terminate = terminate;
    }

    public boolean isTerminated() {
        return this.terminated;
    }
}

