/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.db.dao;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.List;
import org.mycontroller.standalone.db.dao.BaseAbstractDaoImpl;
import org.mycontroller.standalone.db.dao.UserSettingsDao;
import org.mycontroller.standalone.db.tables.User;
import org.mycontroller.standalone.db.tables.UserSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserSettingsDaoImpl
extends BaseAbstractDaoImpl<UserSettings, Integer>
implements UserSettingsDao {
    private static final Logger _logger = LoggerFactory.getLogger(UserSettingsDaoImpl.class);

    public UserSettingsDaoImpl(ConnectionSource connectionSource) throws SQLException {
        super(connectionSource, UserSettings.class);
    }

    @Override
    public void create(UserSettings userSettings) {
        try {
            int count = this.getDao().create((Object)userSettings);
            _logger.debug("Created UserSettings:[{}], Create count:{}", (Object)userSettings, (Object)count);
        }
        catch (SQLException ex) {
            _logger.error("unable to add UserSettings:[{}]", (Object)userSettings, (Object)ex);
        }
    }

    @Override
    public void createOrUpdate(UserSettings userSettings) {
        try {
            Dao.CreateOrUpdateStatus status = this.getDao().createOrUpdate((Object)userSettings);
            _logger.debug("CreateOrUpdate UserSettings:[{}],Create:{},Update:{},Lines Changed:{}", new Object[]{userSettings, status.isCreated(), status.isUpdated(), status.getNumLinesChanged()});
        }
        catch (SQLException ex) {
            _logger.error("unable to CreateOrUpdate UserSettings:[{}]", (Object)userSettings, (Object)ex);
        }
    }

    @Override
    public void delete(UserSettings userSettings) {
        try {
            int count = this.getDao().delete((Object)userSettings);
            _logger.debug("UserSettings:[{}] deleted, Delete count:{}", (Object)userSettings, (Object)count);
        }
        catch (SQLException ex) {
            _logger.error("unable to delete UserSettings:[{}]", (Object)userSettings, (Object)ex);
        }
    }

    @Override
    public void delete(User user, String key) {
        this.delete(new UserSettings(user, key));
    }

    @Override
    public void update(UserSettings userSettings) {
        try {
            this.getDao().update((Object)userSettings);
        }
        catch (SQLException ex) {
            _logger.error("unable to update UserSettings:[{}]", (Object)userSettings, (Object)ex);
        }
    }

    @Override
    public List<UserSettings> getAll() {
        try {
            return this.getDao().queryBuilder().orderBy("key", true).orderBy("id", true).query();
        }
        catch (SQLException ex) {
            _logger.error("unable to get all list", (Throwable)ex);
            return null;
        }
    }

    @Override
    public List<UserSettings> get(User user, List<String> keys) {
        try {
            QueryBuilder queryBuilder = this.getDao().queryBuilder();
            queryBuilder.where().in("key", keys);
            return queryBuilder.orderBy("id", true).query();
        }
        catch (SQLException ex) {
            _logger.error("unable to get list:[{}]", keys, (Object)ex);
            return null;
        }
    }

    @Override
    public List<UserSettings> getLike(User user, String key) {
        try {
            QueryBuilder queryBuilder = this.getDao().queryBuilder();
            queryBuilder.where().like("key", (Object)key);
            return queryBuilder.orderBy("id", true).query();
        }
        catch (SQLException ex) {
            _logger.error("unable to get like:[{}]", (Object)key, (Object)ex);
            return null;
        }
    }

    @Override
    public UserSettings get(UserSettings userSettings) {
        return this.get(userSettings.getUser(), userSettings.getKey());
    }

    @Override
    public UserSettings get(User user, String key) {
        try {
            QueryBuilder queryBuilder = this.getDao().queryBuilder();
            return (UserSettings)queryBuilder.where().eq("key", (Object)key).queryForFirst();
        }
        catch (SQLException ex) {
            _logger.error("unable to get:[key:{}]", (Object)key, (Object)ex);
            return null;
        }
    }
}

