/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.api.jaxrs.mixins;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.plugins.providers.jackson.ResteasyJackson2Provider;
import org.mycontroller.standalone.api.jaxrs.mixins.AlarmDefinitionMixin;
import org.mycontroller.standalone.api.jaxrs.mixins.ForwardPayloadMixin;
import org.mycontroller.standalone.api.jaxrs.mixins.GatewayMixin;
import org.mycontroller.standalone.api.jaxrs.mixins.NodeMixin;
import org.mycontroller.standalone.api.jaxrs.mixins.ResourcesGroupMapMixin;
import org.mycontroller.standalone.api.jaxrs.mixins.ResourcesGroupMixin;
import org.mycontroller.standalone.api.jaxrs.mixins.ResourcesLogsMixin;
import org.mycontroller.standalone.api.jaxrs.mixins.SensorMixin;
import org.mycontroller.standalone.api.jaxrs.mixins.TimerMixin;
import org.mycontroller.standalone.db.tables.AlarmDefinition;
import org.mycontroller.standalone.db.tables.ForwardPayload;
import org.mycontroller.standalone.db.tables.Gateway;
import org.mycontroller.standalone.db.tables.Node;
import org.mycontroller.standalone.db.tables.ResourcesGroup;
import org.mycontroller.standalone.db.tables.ResourcesGroupMap;
import org.mycontroller.standalone.db.tables.ResourcesLogs;
import org.mycontroller.standalone.db.tables.Sensor;
import org.mycontroller.standalone.db.tables.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class McJacksonJson2Provider
extends ResteasyJackson2Provider {
    private static final Logger _logger = LoggerFactory.getLogger(McJacksonJson2Provider.class);

    public void writeTo(Object value, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        ObjectMapper mapper = this.locateMapper(type, mediaType);
        mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.addMixInAnnotations(Gateway.class, GatewayMixin.class);
        mapper.addMixInAnnotations(Node.class, NodeMixin.class);
        mapper.addMixInAnnotations(Sensor.class, SensorMixin.class);
        mapper.addMixInAnnotations(ForwardPayload.class, ForwardPayloadMixin.class);
        mapper.addMixInAnnotations(ResourcesLogs.class, ResourcesLogsMixin.class);
        mapper.addMixInAnnotations(AlarmDefinition.class, AlarmDefinitionMixin.class);
        mapper.addMixInAnnotations(ResourcesGroup.class, ResourcesGroupMixin.class);
        mapper.addMixInAnnotations(ResourcesGroupMap.class, ResourcesGroupMapMixin.class);
        mapper.addMixInAnnotations(Timer.class, TimerMixin.class);
        _logger.debug("Request: Headers:{}", httpHeaders);
        super.writeTo(value, type, genericType, annotations, mediaType, httpHeaders, entityStream);
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        ObjectMapper mapper = this.locateMapper(type, mediaType);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.addMixInAnnotations(Gateway.class, GatewayMixin.class);
        mapper.addMixInAnnotations(Node.class, NodeMixin.class);
        mapper.addMixInAnnotations(Sensor.class, SensorMixin.class);
        mapper.addMixInAnnotations(ForwardPayload.class, ForwardPayloadMixin.class);
        mapper.addMixInAnnotations(AlarmDefinition.class, AlarmDefinitionMixin.class);
        mapper.addMixInAnnotations(ResourcesGroup.class, ResourcesGroupMixin.class);
        mapper.addMixInAnnotations(ResourcesGroupMap.class, ResourcesGroupMapMixin.class);
        mapper.addMixInAnnotations(Timer.class, TimerMixin.class);
        _logger.debug("Request: Headers:{}", httpHeaders);
        return super.readFrom(type, genericType, annotations, mediaType, httpHeaders, entityStream);
    }
}

