/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.alarm;

import org.mycontroller.standalone.AppProperties;
import org.mycontroller.standalone.NumericUtils;
import org.mycontroller.standalone.ObjectFactory;
import org.mycontroller.standalone.alarm.AlarmUtils;
import org.mycontroller.standalone.alarm.INotification;
import org.mycontroller.standalone.db.PayloadOperation;
import org.mycontroller.standalone.db.tables.AlarmDefinition;
import org.mycontroller.standalone.gateway.GatewayUtils;
import org.mycontroller.standalone.model.ResourceModel;
import org.mycontroller.standalone.scheduler.SchedulerUtils;
import org.mycontroller.standalone.timer.TimerSimple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationSendPayLoad
implements INotification {
    private static final Logger _logger = LoggerFactory.getLogger(NotificationSendPayLoad.class);
    private AlarmDefinition alarmDefinition;
    private AppProperties.RESOURCE_TYPE resourceType;
    private Integer resourceId;
    private String payload;
    private long delayTime;

    public NotificationSendPayLoad(AlarmDefinition alarmDefinition) {
        this.alarmDefinition = alarmDefinition;
        this.resourceType = AppProperties.RESOURCE_TYPE.fromString(alarmDefinition.getVariable1());
        this.resourceId = Integer.valueOf(alarmDefinition.getVariable2());
        this.payload = alarmDefinition.getVariable3();
        this.delayTime = alarmDefinition.getVariable4() == null || alarmDefinition.getVariable4().length() == 0 ? 0L : Long.valueOf(alarmDefinition.getVariable4());
    }

    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payLoad) {
        this.payload = payLoad;
    }

    public void setPayLoad(Double payLoad) {
        this.payload = NumericUtils.getDoubleAsString(payLoad);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        ResourceModel resourceModel = new ResourceModel(this.resourceType, this.resourceId);
        builder.append("Target=[").append(resourceModel.getResourceLessDetails()).append("]");
        builder.append(", Payload=").append(this.payload);
        builder.append(", Delay=").append(this.delayTime).append(" Seconds");
        return builder.toString();
    }

    public AppProperties.RESOURCE_TYPE getResourceType() {
        return this.resourceType;
    }

    public Integer getResourceId() {
        return this.resourceId;
    }

    public long getDelayTime() {
        return this.delayTime;
    }

    @Override
    public AlarmDefinition getAlarmDefinition() {
        return this.alarmDefinition;
    }

    @Override
    public void execute(String actualValue) {
        if (this.getDelayTime() == 0L) {
            ResourceModel resourceModel = new ResourceModel(this.getResourceType(), this.getResourceId());
            PayloadOperation payloadOperation = new PayloadOperation(this.getPayload());
            if (resourceModel.getResourceType() == AppProperties.RESOURCE_TYPE.GATEWAY) {
                GatewayUtils.executeGatewayOperation(resourceModel, payloadOperation);
            } else {
                ObjectFactory.getIActionEngine(resourceModel.getNetworkType()).executeSendPayload(resourceModel, payloadOperation);
            }
        } else {
            TimerSimple timerSimple = new TimerSimple(AlarmUtils.getAlarmTimerJobName(this.alarmDefinition), this.getResourceType(), this.getResourceId(), this.getPayload(), 1, this.getDelayTime());
            SchedulerUtils.loadTimerJob(timerSimple.getTimer());
        }
        _logger.debug("Executed 'Send payload' notification, AlarmDefinition:[{}]", (Object)this.alarmDefinition);
    }
}

