/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone;

import java.util.HashMap;
import java.util.Set;
import org.mycontroller.standalone.AppProperties;
import org.mycontroller.standalone.gateway.IGateway;
import org.mycontroller.standalone.interfaces.IActionEngine;
import org.mycontroller.standalone.message.RawMessageQueue;

public class ObjectFactory {
    private static AppProperties appProperties;
    private static RawMessageQueue rawMessageQueue;
    private static HashMap<Integer, IGateway> gateways;
    private static HashMap<AppProperties.NETWORK_TYPE, IActionEngine> iActionEngine;

    private ObjectFactory() {
    }

    public static AppProperties getAppProperties() {
        return appProperties;
    }

    public static void setAppProperties(AppProperties appProperties) {
        ObjectFactory.appProperties = appProperties;
    }

    public static RawMessageQueue getRawMessageQueue() {
        return rawMessageQueue;
    }

    public static void setRawMessageQueue(RawMessageQueue rawMessageQueue) {
        ObjectFactory.rawMessageQueue = rawMessageQueue;
    }

    public static synchronized IGateway getGateway(Integer gatewayId) {
        return gateways.get(gatewayId);
    }

    public static synchronized void addGateway(IGateway iGateway) {
        gateways.put(iGateway.getGateway().getId(), iGateway);
    }

    public static synchronized void removeGateway(Integer gatewayId) {
        gateways.remove(gatewayId);
    }

    public static synchronized Set<Integer> getGatewayIds() {
        return gateways.keySet();
    }

    public static synchronized IActionEngine getIActionEngine(AppProperties.NETWORK_TYPE networktype) {
        return iActionEngine.get((Object)networktype);
    }

    public static synchronized void addIActionEngine(AppProperties.NETWORK_TYPE networktype, IActionEngine actionEngine) {
        iActionEngine.put(networktype, actionEngine);
    }

    static {
        gateways = new HashMap();
        iActionEngine = new HashMap();
    }
}

