/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone;

import java.util.Properties;
import org.mycontroller.standalone.settings.EmailSettings;
import org.mycontroller.standalone.settings.LocationSettings;
import org.mycontroller.standalone.settings.MetricsSettings;
import org.mycontroller.standalone.settings.MyControllerSettings;
import org.mycontroller.standalone.settings.MySensorsSettings;
import org.mycontroller.standalone.settings.SmsSettings;
import org.mycontroller.standalone.settings.UnitsSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppProperties {
    private static final Logger _logger = LoggerFactory.getLogger((String)AppProperties.class.getName());
    public static final String APPLICATION_NAME = "MyController.org";
    public static final String EMAIL_TEMPLATE_ALARM = "../conf/templates/emailTemplateAlarm.html";
    private String dbH2DbLocation;
    private String webFileLocation;
    private boolean isWebHttpsEnabled = false;
    private int webHttpPort;
    private String webSslKeystoreFile;
    private String webSslKeystorePassword;
    private String webSslKeystoreType;
    private String webBindAddress;
    private boolean mqttBrokerEnable;
    private String mqttBrokerBindAddress;
    private Integer mqttBrokerPort;
    private Integer mqttBrokerWebsocketPort;
    private String mqttBrokerPersistentStore;
    MyControllerSettings controllerSettings;
    EmailSettings emailSettings;
    MySensorsSettings mySensorsSettings;
    SmsSettings smsSettings;
    UnitsSettings unitsSettings;
    LocationSettings locationSettings;
    MetricsSettings metricsSettings;

    public AppProperties() {
    }

    public AppProperties(Properties properties) {
        this.loadProperties(properties);
    }

    public void loadProperties(Properties properties) {
        this.dbH2DbLocation = this.getValue(properties, "mcc.db.h2db.location");
        this.webFileLocation = this.getValue(properties, "mcc.web.file.location");
        if (!this.webFileLocation.endsWith("/")) {
            this.webFileLocation = this.webFileLocation + "/";
        }
        this.webHttpPort = Integer.valueOf(this.getValue(properties, "mcc.web.http.port"));
        if (this.getValue(properties, "mcc.web.enable.https") != null && Boolean.valueOf(this.getValue(properties, "mcc.web.enable.https")).booleanValue()) {
            this.isWebHttpsEnabled = true;
            this.webSslKeystoreFile = this.getValue(properties, "mcc.web.ssl.keystore.file");
            this.webSslKeystorePassword = this.getValue(properties, "mcc.web.ssl.keystore.password");
            this.webSslKeystoreType = this.getValue(properties, "mcc.web.ssl.keystore.type");
        }
        this.webBindAddress = this.getValue(properties, "mcc.web.bind.address");
        this.mqttBrokerEnable = Boolean.valueOf(this.getValue(properties, "mcc.mqtt.broker.enable"));
        if (this.mqttBrokerEnable) {
            this.mqttBrokerBindAddress = this.getValue(properties, "mcc.mqtt.broker.bind.address");
            this.mqttBrokerPort = Integer.valueOf(this.getValue(properties, "mcc.mqtt.broker.port"));
            this.mqttBrokerWebsocketPort = Integer.valueOf(this.getValue(properties, "mcc.mqtt.broker.websocket.port"));
            this.mqttBrokerPersistentStore = this.getValue(properties, "mcc.mqtt.broker.persistent.store");
        }
    }

    private String getValue(Properties properties, String key) {
        String value = properties.getProperty(key);
        _logger.debug("Key:{}-->{}", (Object)key, (Object)value);
        if (value != null) {
            return value.trim();
        }
        return null;
    }

    public MC_LANGUAGE getLanguage() {
        return MC_LANGUAGE.fromString(this.controllerSettings.getLanguage());
    }

    public void loadPropertiesFromDb() {
        this.locationSettings = LocationSettings.get();
        this.controllerSettings = MyControllerSettings.get();
        this.mySensorsSettings = MySensorsSettings.get();
        this.emailSettings = EmailSettings.get();
        this.smsSettings = SmsSettings.get();
        this.unitsSettings = UnitsSettings.get();
        this.metricsSettings = MetricsSettings.get();
    }

    private boolean is12HoursSelected() {
        return this.controllerSettings.getTimeFormat().equalsIgnoreCase(MC_TIME_FORMAT.HOURS_12.getText());
    }

    public String getDateFormat() {
        if (this.is12HoursSelected()) {
            return "MMM dd, yyyy hh:mm:ss a";
        }
        return "MMM dd, yyyy HH:mm:ss";
    }

    public String getDateFormatWithoutSeconds() {
        if (this.is12HoursSelected()) {
            return "MMM dd, yyyy hh:mm a";
        }
        return "MMM dd, yyyy HH:mm";
    }

    public String getTimeFormat() {
        if (this.is12HoursSelected()) {
            return "hh:mm:ss a";
        }
        return "HH:mm:ss";
    }

    public static String getOsName() {
        return System.getProperties().getProperty("os.name");
    }

    public static String getOsArch() {
        return System.getProperties().getProperty("os.arch");
    }

    public static String getOsVersion() {
        return System.getProperties().getProperty("os.version");
    }

    public String getDbH2DbLocation() {
        return this.dbH2DbLocation;
    }

    public String getWebFileLocation() {
        return this.webFileLocation;
    }

    public boolean isWebHttpsEnabled() {
        return this.isWebHttpsEnabled;
    }

    public int getWebHttpPort() {
        return this.webHttpPort;
    }

    public String getWebSslKeystoreFile() {
        return this.webSslKeystoreFile;
    }

    public String getWebSslKeystorePassword() {
        return this.webSslKeystorePassword;
    }

    public String getWebSslKeystoreType() {
        return this.webSslKeystoreType;
    }

    public String getWebBindAddress() {
        return this.webBindAddress;
    }

    public boolean isMqttBrokerEnabled() {
        return this.mqttBrokerEnable;
    }

    public String getMqttBrokerBindAddress() {
        return this.mqttBrokerBindAddress;
    }

    public Integer getMqttBrokerPort() {
        return this.mqttBrokerPort;
    }

    public Integer getMqttBrokerWebsocketPort() {
        return this.mqttBrokerWebsocketPort;
    }

    public String getMqttBrokerPersistentStore() {
        return this.mqttBrokerPersistentStore;
    }

    public MyControllerSettings getControllerSettings() {
        return this.controllerSettings;
    }

    public EmailSettings getEmailSettings() {
        return this.emailSettings;
    }

    public MySensorsSettings getMySensorsSettings() {
        return this.mySensorsSettings;
    }

    public SmsSettings getSmsSettings() {
        return this.smsSettings;
    }

    public UnitsSettings getUnitsSettings() {
        return this.unitsSettings;
    }

    public LocationSettings getLocationSettings() {
        return this.locationSettings;
    }

    public MetricsSettings getMetricsSettings() {
        return this.metricsSettings;
    }

    public void setMetricsSettings(MetricsSettings metricsSettings) {
        this.metricsSettings = metricsSettings;
    }

    public String toString() {
        return "AppProperties(dbH2DbLocation=" + this.getDbH2DbLocation() + ", webFileLocation=" + this.getWebFileLocation() + ", isWebHttpsEnabled=" + this.isWebHttpsEnabled() + ", webHttpPort=" + this.getWebHttpPort() + ", webSslKeystoreFile=" + this.getWebSslKeystoreFile() + ", webSslKeystorePassword=" + this.getWebSslKeystorePassword() + ", webSslKeystoreType=" + this.getWebSslKeystoreType() + ", webBindAddress=" + this.getWebBindAddress() + ", mqttBrokerEnable=" + this.mqttBrokerEnable + ", mqttBrokerBindAddress=" + this.getMqttBrokerBindAddress() + ", mqttBrokerPort=" + this.getMqttBrokerPort() + ", mqttBrokerWebsocketPort=" + this.getMqttBrokerWebsocketPort() + ", mqttBrokerPersistentStore=" + this.getMqttBrokerPersistentStore() + ", controllerSettings=" + this.getControllerSettings() + ", emailSettings=" + this.getEmailSettings() + ", mySensorsSettings=" + this.getMySensorsSettings() + ", smsSettings=" + this.getSmsSettings() + ", unitsSettings=" + this.getUnitsSettings() + ", locationSettings=" + this.getLocationSettings() + ", metricsSettings=" + this.getMetricsSettings() + ")";
    }

    public static enum SMS_VENDOR {
        PLIVO("Plivo"),
        TWILIO("Twilio");

        private final String name;

        private SMS_VENDOR(String name) {
            this.name = name;
        }

        public String getText() {
            return this.name;
        }

        public static SMS_VENDOR get(int id) {
            for (SMS_VENDOR type : SMS_VENDOR.values()) {
                if (type.ordinal() != id) continue;
                return type;
            }
            throw new IllegalArgumentException(String.valueOf(id));
        }

        public static SMS_VENDOR fromString(String text) {
            if (text != null) {
                for (SMS_VENDOR type : SMS_VENDOR.values()) {
                    if (!text.equalsIgnoreCase(type.getText())) continue;
                    return type;
                }
            }
            return null;
        }
    }

    public static enum UNIT_CONFIG {
        METRIC("Metric"),
        IMPERIAL("Imperial");

        private String value;

        public static UNIT_CONFIG get(int id) {
            for (UNIT_CONFIG type : UNIT_CONFIG.values()) {
                if (type.ordinal() != id) continue;
                return type;
            }
            throw new IllegalArgumentException(String.valueOf(id));
        }

        private UNIT_CONFIG(String value) {
            this.value = value;
        }

        public String getText() {
            return this.value;
        }

        public static UNIT_CONFIG fromString(String text) {
            if (text != null) {
                for (UNIT_CONFIG type : UNIT_CONFIG.values()) {
                    if (!text.equalsIgnoreCase(type.getText())) continue;
                    return type;
                }
            }
            return null;
        }
    }

    public static enum RESOURCE_TYPE {
        GATEWAY("Gateway"),
        NODE("Node"),
        SENSOR("Sensor"),
        SENSOR_VARIABLE("Sensor variable"),
        RESOURCES_GROUP("Resources group"),
        ALARM_DEFINITION("Alarm definition"),
        TIMER("Timer");

        private String value;

        public static RESOURCE_TYPE get(int id) {
            for (RESOURCE_TYPE trigger_type : RESOURCE_TYPE.values()) {
                if (trigger_type.ordinal() != id) continue;
                return trigger_type;
            }
            throw new IllegalArgumentException(String.valueOf(id));
        }

        private RESOURCE_TYPE(String value) {
            this.value = value;
        }

        public String getText() {
            return this.value;
        }

        public static RESOURCE_TYPE fromString(String text) {
            if (text != null) {
                for (RESOURCE_TYPE type : RESOURCE_TYPE.values()) {
                    if (!text.equalsIgnoreCase(type.getText())) continue;
                    return type;
                }
            }
            return null;
        }
    }

    public static enum NETWORK_TYPE {
        MY_SENSORS("MySensors");

        private final String type;

        private NETWORK_TYPE(String type) {
            this.type = type;
        }

        public String getText() {
            return this.type;
        }

        public static NETWORK_TYPE get(int id) {
            for (NETWORK_TYPE type : NETWORK_TYPE.values()) {
                if (type.ordinal() != id) continue;
                return type;
            }
            throw new IllegalArgumentException(String.valueOf(id));
        }

        public static NETWORK_TYPE fromString(String text) {
            if (text != null) {
                for (NETWORK_TYPE type : NETWORK_TYPE.values()) {
                    if (!text.equalsIgnoreCase(type.getText())) continue;
                    return type;
                }
            }
            return null;
        }
    }

    public static enum STATE {
        UP("Up"),
        DOWN("Down"),
        UNAVAILABLE("Unavailable"),
        ON("On"),
        OFF("Off");

        private final String type;

        private STATE(String type) {
            this.type = type;
        }

        public String getText() {
            return this.type;
        }

        public static STATE get(int id) {
            for (STATE type : STATE.values()) {
                if (type.ordinal() != id) continue;
                return type;
            }
            throw new IllegalArgumentException(String.valueOf(id));
        }

        public static STATE fromString(String text) {
            if (text != null) {
                for (STATE type : STATE.values()) {
                    if (!text.equalsIgnoreCase(type.getText())) continue;
                    return type;
                }
            }
            return null;
        }
    }

    public static enum MC_TIME_FORMAT {
        HOURS_12("12 hours"),
        HOURS_24("24 hours");

        private final String name;

        private MC_TIME_FORMAT(String name) {
            this.name = name;
        }

        public String getText() {
            return this.name;
        }

        public static MC_TIME_FORMAT get(int id) {
            for (MC_TIME_FORMAT type : MC_TIME_FORMAT.values()) {
                if (type.ordinal() != id) continue;
                return type;
            }
            throw new IllegalArgumentException(String.valueOf(id));
        }

        public static MC_TIME_FORMAT fromString(String text) {
            if (text != null) {
                for (MC_TIME_FORMAT type : MC_TIME_FORMAT.values()) {
                    if (!text.equalsIgnoreCase(type.getText())) continue;
                    return type;
                }
            }
            return null;
        }
    }

    public static enum MC_LANGUAGE {
        EN_US("English (US)"),
        TA_IN("\u0ba4\u0bae\u0bbf\u0bb4\u0bcd (IN)"),
        DE_DE("Deutsch (DE)"),
        RU_RU("Russian (RU)");

        private final String name;

        private MC_LANGUAGE(String name) {
            this.name = name;
        }

        public String getText() {
            return this.name;
        }

        public static MC_LANGUAGE get(int id) {
            for (MC_LANGUAGE type : MC_LANGUAGE.values()) {
                if (type.ordinal() != id) continue;
                return type;
            }
            throw new IllegalArgumentException(String.valueOf(id));
        }

        public static MC_LANGUAGE fromString(String text) {
            if (text != null) {
                for (MC_LANGUAGE type : MC_LANGUAGE.values()) {
                    if (!text.equalsIgnoreCase(type.getText())) continue;
                    return type;
                }
            }
            return null;
        }
    }
}

