/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.settings;

import com.fasterxml.jackson.annotation.JsonTypeName;
import java.beans.ConstructorProperties;
import org.mycontroller.standalone.settings.SettingsUtils;

@JsonTypeName(value="smsSettings")
public class SmsSettings {
    public static final String KEY_SMS = "sms";
    public static final String SKEY_VENDOR = "vendor";
    public static final String SKEY_AUTH_SID = "sid";
    public static final String SKEY_AUTH_TOKEN = "authToken";
    public static final String SKEY_FROM_NUMBER = "fromAddress";
    private String vendor;
    private String authSid;
    private String authToken;
    private String fromNumber;

    public static SmsSettings get() {
        return SmsSettings.builder().vendor(SmsSettings.getValue(SKEY_VENDOR)).authSid(SmsSettings.getValue(SKEY_AUTH_SID)).authToken(SmsSettings.getValue(SKEY_AUTH_TOKEN)).fromNumber(SmsSettings.getValue(SKEY_FROM_NUMBER)).build();
    }

    public void save() {
        SmsSettings.updateValue(SKEY_VENDOR, this.vendor);
        SmsSettings.updateValue(SKEY_AUTH_SID, this.authSid);
        SmsSettings.updateValue(SKEY_AUTH_TOKEN, this.authToken);
        SmsSettings.updateValue(SKEY_FROM_NUMBER, this.fromNumber);
    }

    private static String getValue(String subKey) {
        return SettingsUtils.getValue(KEY_SMS, subKey);
    }

    private static void updateValue(String subKey, Object value) {
        SettingsUtils.updateValue(KEY_SMS, subKey, value);
    }

    public static SmsSettingsBuilder builder() {
        return new SmsSettingsBuilder();
    }

    public String toString() {
        return "SmsSettings(vendor=" + this.getVendor() + ", authSid=" + this.getAuthSid() + ", authToken=" + this.getAuthToken() + ", fromNumber=" + this.getFromNumber() + ")";
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getAuthSid() {
        return this.authSid;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public String getFromNumber() {
        return this.fromNumber;
    }

    public SmsSettings() {
    }

    @ConstructorProperties(value={"vendor", "authSid", "authToken", "fromNumber"})
    public SmsSettings(String vendor, String authSid, String authToken, String fromNumber) {
        this.vendor = vendor;
        this.authSid = authSid;
        this.authToken = authToken;
        this.fromNumber = fromNumber;
    }

    public static class SmsSettingsBuilder {
        private String vendor;
        private String authSid;
        private String authToken;
        private String fromNumber;

        SmsSettingsBuilder() {
        }

        public SmsSettingsBuilder vendor(String vendor) {
            this.vendor = vendor;
            return this;
        }

        public SmsSettingsBuilder authSid(String authSid) {
            this.authSid = authSid;
            return this;
        }

        public SmsSettingsBuilder authToken(String authToken) {
            this.authToken = authToken;
            return this;
        }

        public SmsSettingsBuilder fromNumber(String fromNumber) {
            this.fromNumber = fromNumber;
            return this;
        }

        public SmsSettings build() {
            return new SmsSettings(this.vendor, this.authSid, this.authToken, this.fromNumber);
        }

        public String toString() {
            return "SmsSettings.SmsSettingsBuilder(vendor=" + this.vendor + ", authSid=" + this.authSid + ", authToken=" + this.authToken + ", fromNumber=" + this.fromNumber + ")";
        }
    }
}

