/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.settings;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.beans.ConstructorProperties;
import org.mycontroller.standalone.NumericUtils;
import org.mycontroller.standalone.settings.SettingsUtils;

@JsonTypeName(value="myControllerSettings")
public class MyControllerSettings {
    public static final String KEY_MY_CONTROLLER = "myController";
    public static final String SKEY_LANGUAGE = "language";
    public static final String SKEY_TIME_FORMAT = "timeFormat";
    public static final String SKEY_VERSION = "version";
    public static final String SKEY_DB_VERSION = "dbVersion";
    public static final String SKEY_ALIVE_CHECK_INTERVAL = "aliveCheckInterval";
    public static final String SKEY_UNIT_CONFIG = "unitConfig";
    public static final String SKEY_LOGIN_MESSAGE = "loginMessage";
    private String language;
    private String timeFormat;
    private String version;
    private Integer dbVersion;
    private Long aliveCheckInterval;
    private String unitConfig;
    private String loginMessage;

    public static MyControllerSettings get() {
        return MyControllerSettings.builder().language(MyControllerSettings.getValue(SKEY_LANGUAGE)).timeFormat(MyControllerSettings.getValue(SKEY_TIME_FORMAT)).version(MyControllerSettings.getValue(SKEY_VERSION)).dbVersion(NumericUtils.getInteger(MyControllerSettings.getValue(SKEY_DB_VERSION))).aliveCheckInterval(NumericUtils.getLong(MyControllerSettings.getValue(SKEY_ALIVE_CHECK_INTERVAL))).unitConfig(MyControllerSettings.getValue(SKEY_UNIT_CONFIG)).loginMessage(MyControllerSettings.getValue(SKEY_LOGIN_MESSAGE)).build();
    }

    public void save() {
        if (this.language != null) {
            this.updateValue(SKEY_LANGUAGE, this.language);
        }
        if (this.timeFormat != null) {
            this.updateValue(SKEY_TIME_FORMAT, this.timeFormat);
        }
        if (this.aliveCheckInterval != null) {
            this.updateValue(SKEY_ALIVE_CHECK_INTERVAL, this.aliveCheckInterval);
        }
        if (this.unitConfig != null) {
            this.updateValue(SKEY_UNIT_CONFIG, this.unitConfig);
        }
        if (this.loginMessage != null) {
            this.updateValue(SKEY_LOGIN_MESSAGE, this.loginMessage);
        }
    }

    private static String getValue(String subKey) {
        return SettingsUtils.getValue(KEY_MY_CONTROLLER, subKey);
    }

    private void updateValue(String subKey, Object value) {
        SettingsUtils.updateValue(KEY_MY_CONTROLLER, subKey, value);
    }

    @JsonIgnore
    public void updateInternal() {
        if (this.version != null) {
            this.updateValue(SKEY_VERSION, this.version);
        }
        if (this.dbVersion != null) {
            this.updateValue(SKEY_DB_VERSION, this.dbVersion);
        }
    }

    public static MyControllerSettingsBuilder builder() {
        return new MyControllerSettingsBuilder();
    }

    public String toString() {
        return "MyControllerSettings(language=" + this.getLanguage() + ", timeFormat=" + this.getTimeFormat() + ", version=" + this.getVersion() + ", dbVersion=" + this.getDbVersion() + ", aliveCheckInterval=" + this.getAliveCheckInterval() + ", unitConfig=" + this.getUnitConfig() + ", loginMessage=" + this.getLoginMessage() + ")";
    }

    public String getLanguage() {
        return this.language;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public String getVersion() {
        return this.version;
    }

    public Integer getDbVersion() {
        return this.dbVersion;
    }

    public Long getAliveCheckInterval() {
        return this.aliveCheckInterval;
    }

    public String getUnitConfig() {
        return this.unitConfig;
    }

    public String getLoginMessage() {
        return this.loginMessage;
    }

    public MyControllerSettings() {
    }

    @ConstructorProperties(value={"language", "timeFormat", "version", "dbVersion", "aliveCheckInterval", "unitConfig", "loginMessage"})
    public MyControllerSettings(String language, String timeFormat, String version, Integer dbVersion, Long aliveCheckInterval, String unitConfig, String loginMessage) {
        this.language = language;
        this.timeFormat = timeFormat;
        this.version = version;
        this.dbVersion = dbVersion;
        this.aliveCheckInterval = aliveCheckInterval;
        this.unitConfig = unitConfig;
        this.loginMessage = loginMessage;
    }

    public static class MyControllerSettingsBuilder {
        private String language;
        private String timeFormat;
        private String version;
        private Integer dbVersion;
        private Long aliveCheckInterval;
        private String unitConfig;
        private String loginMessage;

        MyControllerSettingsBuilder() {
        }

        public MyControllerSettingsBuilder language(String language) {
            this.language = language;
            return this;
        }

        public MyControllerSettingsBuilder timeFormat(String timeFormat) {
            this.timeFormat = timeFormat;
            return this;
        }

        public MyControllerSettingsBuilder version(String version) {
            this.version = version;
            return this;
        }

        public MyControllerSettingsBuilder dbVersion(Integer dbVersion) {
            this.dbVersion = dbVersion;
            return this;
        }

        public MyControllerSettingsBuilder aliveCheckInterval(Long aliveCheckInterval) {
            this.aliveCheckInterval = aliveCheckInterval;
            return this;
        }

        public MyControllerSettingsBuilder unitConfig(String unitConfig) {
            this.unitConfig = unitConfig;
            return this;
        }

        public MyControllerSettingsBuilder loginMessage(String loginMessage) {
            this.loginMessage = loginMessage;
            return this;
        }

        public MyControllerSettings build() {
            return new MyControllerSettings(this.language, this.timeFormat, this.version, this.dbVersion, this.aliveCheckInterval, this.unitConfig, this.loginMessage);
        }

        public String toString() {
            return "MyControllerSettings.MyControllerSettingsBuilder(language=" + this.language + ", timeFormat=" + this.timeFormat + ", version=" + this.version + ", dbVersion=" + this.dbVersion + ", aliveCheckInterval=" + this.aliveCheckInterval + ", unitConfig=" + this.unitConfig + ", loginMessage=" + this.loginMessage + ")";
        }
    }
}

