/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.mqttbroker;

import io.moquette.server.config.IConfig;
import java.util.Properties;
import org.h2.store.fs.FileUtils;
import org.mycontroller.standalone.ObjectFactory;
import org.mycontroller.standalone.mqttbroker.MqttAuthenticatorImpl;
import org.mycontroller.standalone.mqttbroker.MqttAuthorizatorImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerConfiguration
implements IConfig {
    private static final Logger _logger = LoggerFactory.getLogger((String)BrokerConfiguration.class.getName());
    private final Properties m_properties = new Properties();

    public BrokerConfiguration() {
        this.createDefaultLocations();
        this.loadProperties();
    }

    private void createDefaultLocations() {
        FileUtils.createDirectory((String)FileUtils.getParent((String)ObjectFactory.getAppProperties().getMqttBrokerPersistentStore()));
    }

    private void loadProperties() {
        this.m_properties.put("host", ObjectFactory.getAppProperties().getMqttBrokerBindAddress());
        this.m_properties.put("port", String.valueOf(ObjectFactory.getAppProperties().getMqttBrokerPort()));
        this.m_properties.put("websocket_port", String.valueOf(ObjectFactory.getAppProperties().getMqttBrokerWebsocketPort()));
        this.m_properties.put("password_file", "");
        this.m_properties.put("persistent_store", ObjectFactory.getAppProperties().getMqttBrokerPersistentStore());
        this.m_properties.put("allow_anonymous", (Object)true);
        this.m_properties.put("authenticator_class", MqttAuthenticatorImpl.class.getName());
        this.m_properties.put("authorizator_class", MqttAuthorizatorImpl.class.getName());
        _logger.debug("Properties:[{}]", (Object)this.m_properties);
    }

    public void setProperty(String name, String value) {
        this.m_properties.setProperty(name, value);
    }

    public String getProperty(String name) {
        return this.m_properties.getProperty(name);
    }

    public String getProperty(String name, String defaultValue) {
        return this.m_properties.getProperty(name, defaultValue);
    }
}

