/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.db.tables;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import java.beans.ConstructorProperties;
import org.mycontroller.standalone.AppProperties;
import org.mycontroller.standalone.db.tables.ResourcesGroup;
import org.mycontroller.standalone.model.ResourceModel;

@DatabaseTable(tableName="resources_group_map")
public class ResourcesGroupMap {
    public static final String KEY_ID = "id";
    public static final String KEY_RESOURCE_TYPE = "resourceType";
    public static final String KEY_RESOURCE_ID = "resourceId";
    public static final String KEY_GROUP_ID = "groupId";
    public static final String KEY_PAYLOAD_ON = "payloadOn";
    public static final String KEY_PAYLOAD_OFF = "payloadOff";
    @DatabaseField(generatedId=true, columnName="id")
    private Integer id;
    @DatabaseField(canBeNull=false, foreign=true, uniqueCombo=true, columnName="groupId", foreignAutoRefresh=true, maxForeignAutoRefreshLevel=1)
    private ResourcesGroup resourcesGroup;
    @DatabaseField(dataType=DataType.ENUM_STRING, uniqueCombo=true, canBeNull=false, columnName="resourceType")
    private AppProperties.RESOURCE_TYPE resourceType;
    @DatabaseField(canBeNull=false, uniqueCombo=true, columnName="resourceId")
    private Integer resourceId;
    @DatabaseField(canBeNull=true, columnName="payloadOn")
    private String payloadOn;
    @DatabaseField(canBeNull=true, columnName="payloadOff")
    private String payloadOff;

    public String getResource() {
        ResourceModel resourceModel = new ResourceModel(this.resourceType, this.resourceId);
        return resourceModel.getResourceLessDetails();
    }

    public static ResourcesGroupMapBuilder builder() {
        return new ResourcesGroupMapBuilder();
    }

    public Integer getId() {
        return this.id;
    }

    public ResourcesGroup getResourcesGroup() {
        return this.resourcesGroup;
    }

    public AppProperties.RESOURCE_TYPE getResourceType() {
        return this.resourceType;
    }

    public Integer getResourceId() {
        return this.resourceId;
    }

    public String getPayloadOn() {
        return this.payloadOn;
    }

    public String getPayloadOff() {
        return this.payloadOff;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setResourcesGroup(ResourcesGroup resourcesGroup) {
        this.resourcesGroup = resourcesGroup;
    }

    public void setResourceType(AppProperties.RESOURCE_TYPE resourceType) {
        this.resourceType = resourceType;
    }

    public void setResourceId(Integer resourceId) {
        this.resourceId = resourceId;
    }

    public void setPayloadOn(String payloadOn) {
        this.payloadOn = payloadOn;
    }

    public void setPayloadOff(String payloadOff) {
        this.payloadOff = payloadOff;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourcesGroupMap)) {
            return false;
        }
        ResourcesGroupMap other = (ResourcesGroupMap)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        ResourcesGroup this$resourcesGroup = this.getResourcesGroup();
        ResourcesGroup other$resourcesGroup = other.getResourcesGroup();
        if (this$resourcesGroup == null ? other$resourcesGroup != null : !((Object)this$resourcesGroup).equals(other$resourcesGroup)) {
            return false;
        }
        AppProperties.RESOURCE_TYPE this$resourceType = this.getResourceType();
        AppProperties.RESOURCE_TYPE other$resourceType = other.getResourceType();
        if (this$resourceType == null ? other$resourceType != null : !((Object)((Object)this$resourceType)).equals((Object)other$resourceType)) {
            return false;
        }
        Integer this$resourceId = this.getResourceId();
        Integer other$resourceId = other.getResourceId();
        if (this$resourceId == null ? other$resourceId != null : !((Object)this$resourceId).equals(other$resourceId)) {
            return false;
        }
        String this$payloadOn = this.getPayloadOn();
        String other$payloadOn = other.getPayloadOn();
        if (this$payloadOn == null ? other$payloadOn != null : !this$payloadOn.equals(other$payloadOn)) {
            return false;
        }
        String this$payloadOff = this.getPayloadOff();
        String other$payloadOff = other.getPayloadOff();
        return !(this$payloadOff == null ? other$payloadOff != null : !this$payloadOff.equals(other$payloadOff));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResourcesGroupMap;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        ResourcesGroup $resourcesGroup = this.getResourcesGroup();
        result = result * 59 + ($resourcesGroup == null ? 43 : ((Object)$resourcesGroup).hashCode());
        AppProperties.RESOURCE_TYPE $resourceType = this.getResourceType();
        result = result * 59 + ($resourceType == null ? 43 : ((Object)((Object)$resourceType)).hashCode());
        Integer $resourceId = this.getResourceId();
        result = result * 59 + ($resourceId == null ? 43 : ((Object)$resourceId).hashCode());
        String $payloadOn = this.getPayloadOn();
        result = result * 59 + ($payloadOn == null ? 43 : $payloadOn.hashCode());
        String $payloadOff = this.getPayloadOff();
        result = result * 59 + ($payloadOff == null ? 43 : $payloadOff.hashCode());
        return result;
    }

    public ResourcesGroupMap() {
    }

    @ConstructorProperties(value={"id", "resourcesGroup", "resourceType", "resourceId", "payloadOn", "payloadOff"})
    public ResourcesGroupMap(Integer id, ResourcesGroup resourcesGroup, AppProperties.RESOURCE_TYPE resourceType, Integer resourceId, String payloadOn, String payloadOff) {
        this.id = id;
        this.resourcesGroup = resourcesGroup;
        this.resourceType = resourceType;
        this.resourceId = resourceId;
        this.payloadOn = payloadOn;
        this.payloadOff = payloadOff;
    }

    public String toString() {
        return "ResourcesGroupMap(id=" + this.getId() + ", resourcesGroup=" + this.getResourcesGroup() + ", resourceType=" + (Object)((Object)this.getResourceType()) + ", resourceId=" + this.getResourceId() + ", payloadOn=" + this.getPayloadOn() + ", payloadOff=" + this.getPayloadOff() + ")";
    }

    public static class ResourcesGroupMapBuilder {
        private Integer id;
        private ResourcesGroup resourcesGroup;
        private AppProperties.RESOURCE_TYPE resourceType;
        private Integer resourceId;
        private String payloadOn;
        private String payloadOff;

        ResourcesGroupMapBuilder() {
        }

        public ResourcesGroupMapBuilder id(Integer id) {
            this.id = id;
            return this;
        }

        public ResourcesGroupMapBuilder resourcesGroup(ResourcesGroup resourcesGroup) {
            this.resourcesGroup = resourcesGroup;
            return this;
        }

        public ResourcesGroupMapBuilder resourceType(AppProperties.RESOURCE_TYPE resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public ResourcesGroupMapBuilder resourceId(Integer resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public ResourcesGroupMapBuilder payloadOn(String payloadOn) {
            this.payloadOn = payloadOn;
            return this;
        }

        public ResourcesGroupMapBuilder payloadOff(String payloadOff) {
            this.payloadOff = payloadOff;
            return this;
        }

        public ResourcesGroupMap build() {
            return new ResourcesGroupMap(this.id, this.resourcesGroup, this.resourceType, this.resourceId, this.payloadOn, this.payloadOff);
        }

        public String toString() {
            return "ResourcesGroupMap.ResourcesGroupMapBuilder(id=" + this.id + ", resourcesGroup=" + this.resourcesGroup + ", resourceType=" + (Object)((Object)this.resourceType) + ", resourceId=" + this.resourceId + ", payloadOn=" + this.payloadOn + ", payloadOff=" + this.payloadOff + ")";
        }
    }
}

