/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.db.dao;

import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.UpdateBuilder;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.mycontroller.standalone.MYCMessages;
import org.mycontroller.standalone.api.jaxrs.mapper.Query;
import org.mycontroller.standalone.api.jaxrs.mapper.QueryResponse;
import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.db.DbException;
import org.mycontroller.standalone.db.dao.BaseAbstractDaoImpl;
import org.mycontroller.standalone.db.dao.SensorDao;
import org.mycontroller.standalone.db.tables.Node;
import org.mycontroller.standalone.db.tables.Sensor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensorDaoImpl
extends BaseAbstractDaoImpl<Sensor, Integer>
implements SensorDao {
    private static final Logger _logger = LoggerFactory.getLogger(SensorDaoImpl.class);

    public SensorDaoImpl(ConnectionSource connectionSource) throws SQLException {
        super(connectionSource, Sensor.class);
    }

    @Override
    public void create(Integer gatewayId, String nodeEui, Sensor sensor) {
        this.create(DaoUtils.getNodeDao().get(gatewayId, nodeEui).getId(), sensor);
    }

    @Override
    public void create(Integer nodeId, Sensor sensor) {
        sensor.setNode(Node.builder().id(nodeId).build());
        this.create(sensor);
    }

    @Override
    public void createOrUpdate(Integer gatewayId, String nodeEui, Sensor sensor) {
        sensor.setNode(DaoUtils.getNodeDao().get(gatewayId, nodeEui));
        this.createOrUpdate(sensor);
    }

    @Override
    public void createOrUpdate(Integer nodeId, Sensor sensor) {
        sensor.setNode(Node.builder().id(nodeId).build());
        this.createOrUpdate(sensor);
    }

    @Override
    public void create(Integer gatewayId, String nodeEui, Integer sensorId) {
        this.create(DaoUtils.getNodeDao().get(gatewayId, nodeEui).getId(), Sensor.builder().sensorId(sensorId).build());
    }

    @Override
    public void delete(Sensor sensor) {
        try {
            this.nodeIdSensorIdnullCheck(sensor);
            DeleteBuilder deleteBuilder = this.getDao().deleteBuilder();
            deleteBuilder.where().eq("nodeId", (Object)sensor.getNode().getId()).and().eq("sensorId", (Object)sensor.getSensorId());
            int deleteCount = deleteBuilder.delete();
            _logger.debug("Deleted senosor:[{}], delete count:{}", (Object)sensor, (Object)deleteCount);
        }
        catch (SQLException ex) {
            _logger.error("unable to delete, sensor:{}", (Object)sensor, (Object)ex);
        }
        catch (DbException dbEx) {
            _logger.error("unable to delete, sensor:{}", (Object)sensor, (Object)dbEx);
        }
    }

    @Override
    public void delete(Integer gatewayId, String nodeEui, Integer sensorId) {
        Sensor sensor = Sensor.builder().sensorId(sensorId).build();
        sensor.setNode(DaoUtils.getNodeDao().get(gatewayId, nodeEui));
        this.delete(sensor);
    }

    @Override
    public void update(Sensor sensor) {
        try {
            this.nodeIdSensorIdnullCheck(sensor);
            UpdateBuilder updateBuilder = this.getDao().updateBuilder();
            if (sensor.getType() != null) {
                updateBuilder.updateColumnValue("type", (Object)sensor.getType());
            }
            if (sensor.getName() != null) {
                updateBuilder.updateColumnValue("name", (Object)sensor.getName());
            }
            if (sensor.getLastSeen() != null) {
                updateBuilder.updateColumnValue("lastSeen", (Object)sensor.getLastSeen());
            }
            if (sensor.getSensorId() != null) {
                updateBuilder.updateColumnValue("sensorId", (Object)sensor.getSensorId());
            }
            updateBuilder.where().eq("id", (Object)sensor.getId());
            int updateCount = updateBuilder.update();
            _logger.debug("Updated senosor:[{}], update count:{}", (Object)sensor, (Object)updateCount);
        }
        catch (SQLException ex) {
            _logger.error("unable to get", (Throwable)ex);
        }
        catch (DbException dbEx) {
            _logger.error("unable to update, sensor:{}", (Object)sensor, (Object)dbEx);
        }
    }

    @Override
    public void update(Integer nodeId, Sensor sensor) {
        sensor.setNode(Node.builder().id(nodeId).build());
        this.update(sensor);
    }

    @Override
    public void update(Integer gatewayId, String nodeEui, Sensor sensor) {
        sensor.setNode(DaoUtils.getNodeDao().get(gatewayId, nodeEui));
        this.update(sensor);
    }

    @Override
    public List<Sensor> getAll(Integer nodeId) {
        try {
            if (nodeId == null) {
                return null;
            }
            return this.getDao().queryForEq("nodeId", (Object)nodeId);
        }
        catch (SQLException ex) {
            _logger.error("unable to get all list with node id:{}", (Object)nodeId, (Object)ex);
            return null;
        }
    }

    @Override
    public List<Sensor> getAll(String nodeEui, Integer gatewayId) {
        return this.getAll(DaoUtils.getNodeDao().get(gatewayId, nodeEui).getId());
    }

    @Override
    public List<Sensor> getByType(String typeString) {
        try {
            return this.getDao().queryForEq("type", (Object)MYCMessages.MESSAGE_TYPE_PRESENTATION.valueOf(typeString));
        }
        catch (SQLException ex) {
            _logger.error("unable to get all list with typeString: {}", (Object)typeString, (Object)ex);
            return null;
        }
    }

    @Override
    public List<Sensor> getAll() {
        try {
            return this.getDao().queryForAll();
        }
        catch (SQLException ex) {
            _logger.error("unable to get all list", (Throwable)ex);
            return null;
        }
    }

    @Override
    public List<Sensor> getAllByNodeIds(List<Integer> nodeIds) {
        try {
            if (nodeIds == null) {
                return null;
            }
            QueryBuilder queryBuilder = this.getDao().queryBuilder();
            queryBuilder.where().in("nodeId", nodeIds);
            return queryBuilder.query();
        }
        catch (SQLException ex) {
            _logger.error("unable to get all list with nodeIds:{}", nodeIds, (Object)ex);
            return null;
        }
    }

    @Override
    public Sensor get(Integer nodeId, Integer sensorId) {
        try {
            this.nodeIdSensorIdnullCheck(nodeId, sensorId);
            return (Sensor)this.getDao().queryForFirst(this.getDao().queryBuilder().where().eq("nodeId", (Object)nodeId).and().eq("sensorId", (Object)sensorId).prepare());
        }
        catch (SQLException ex) {
            _logger.error("unable to get", (Throwable)ex);
        }
        catch (DbException dbEx) {
            _logger.error("unable to get, nodeId:{},sensorId:{}", new Object[]{nodeId, sensorId, dbEx});
        }
        return null;
    }

    @Override
    public Sensor get(Integer gatewayId, String nodeEui, Integer sensorId) {
        Node node = DaoUtils.getNodeDao().get(gatewayId, nodeEui);
        if (node != null) {
            return this.get(node.getId(), sensorId);
        }
        return null;
    }

    @Override
    public Sensor get(Sensor sensor) {
        try {
            this.nodeIdSensorIdnullCheck(sensor);
            return this.get(sensor.getNode().getId(), sensor.getSensorId());
        }
        catch (DbException ex) {
            _logger.error("unable to get", (Throwable)ex);
            return null;
        }
    }

    private void nodeIdSensorIdnullCheck(Integer nodeId, Integer sensorId) throws DbException {
        if (nodeId != null && sensorId != null) {
            return;
        }
        throw new DbException("SensorId or nodeId should not be a NULL, nodeId:" + nodeId + ",SensorId:" + sensorId);
    }

    private void nodeIdSensorIdnullCheck(Sensor sensor) throws DbException {
        if (sensor != null && sensor.getSensorId() != null && sensor.getNode() != null && sensor.getNode().getId() != null) {
            return;
        }
        throw new DbException("SensorId or NodeId should not be a NULL, Sensor:" + sensor);
    }

    @Override
    public List<Integer> getSensorIds(String nodeEui, Integer gatewayId) {
        List<Sensor> sensors = this.getAll(nodeEui, gatewayId);
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (Sensor sensor : sensors) {
            ids.add(sensor.getId());
        }
        return ids;
    }

    @Override
    public long countOf(Integer nodeId) {
        try {
            QueryBuilder queryBuilder = this.getDao().queryBuilder();
            queryBuilder.where().eq("nodeId", (Object)nodeId);
            return queryBuilder.countOf();
        }
        catch (SQLException ex) {
            _logger.error("unable to get Sensor count:[NodeId:{}]", (Object)nodeId, (Object)ex);
            return 0L;
        }
    }

    @Override
    public List<Sensor> getAllByIds(List<Integer> ids) {
        try {
            if (ids != null && !ids.isEmpty()) {
                QueryBuilder queryBuilder = this.getDao().queryBuilder();
                queryBuilder.where().in("id", ids);
                return queryBuilder.query();
            }
        }
        catch (SQLException ex) {
            _logger.error("unable to get all list with sensor Ids:{}", ids, (Object)ex);
        }
        return null;
    }

    @Override
    public QueryResponse getAll(Query query) {
        try {
            return this.getQueryResponse(query, "id");
        }
        catch (SQLException ex) {
            _logger.error("unable to run query:[{}]", (Object)query, (Object)ex);
            return null;
        }
    }

    @Override
    public List<Sensor> getAll(List<Integer> ids) {
        return this.getAll("id", ids);
    }
}

