/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.db.dao;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.List;
import org.mycontroller.standalone.api.jaxrs.mapper.Query;
import org.mycontroller.standalone.api.jaxrs.mapper.QueryResponse;
import org.mycontroller.standalone.db.dao.BaseAbstractDaoImpl;
import org.mycontroller.standalone.db.dao.ResourcesGroupDao;
import org.mycontroller.standalone.db.tables.ResourcesGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcesGroupDaoImpl
extends BaseAbstractDaoImpl<ResourcesGroup, Integer>
implements ResourcesGroupDao {
    private static final Logger _logger = LoggerFactory.getLogger(ResourcesGroupDaoImpl.class);

    public ResourcesGroupDaoImpl(ConnectionSource connectionSource) throws SQLException {
        super(connectionSource, ResourcesGroup.class);
    }

    @Override
    public void create(ResourcesGroup resourcesGroup) {
        try {
            int count = this.getDao().create((Object)resourcesGroup);
            _logger.debug("Created ResourcesGroup:[{}], Create count:{}", (Object)resourcesGroup, (Object)count);
        }
        catch (SQLException ex) {
            _logger.error("unable to add ResourcesGroup:[{}]", (Object)resourcesGroup, (Object)ex);
        }
    }

    @Override
    public void createOrUpdate(ResourcesGroup resourcesGroup) {
        try {
            Dao.CreateOrUpdateStatus status = this.getDao().createOrUpdate((Object)resourcesGroup);
            _logger.debug("CreateOrUpdate ResourcesGroup:[{}],Create:{},Update:{},Lines Changed:{}", new Object[]{resourcesGroup, status.isCreated(), status.isUpdated(), status.getNumLinesChanged()});
        }
        catch (SQLException ex) {
            _logger.error("unable to CreateOrUpdate ResourcesGroup:[{}]", (Object)resourcesGroup, (Object)ex);
        }
    }

    private void delete(Integer id, String name) {
        try {
            int count = 0;
            if (id != null) {
                count = this.getDao().deleteById((Object)id);
            } else if (name != null) {
                DeleteBuilder deleteBuilder = this.getDao().deleteBuilder();
                deleteBuilder.where().eq("name", (Object)name);
                count = deleteBuilder.delete();
            }
            _logger.debug("ResourcesGroup:[id:{}, name:{}] deleted, Delete count:{}", new Object[]{id, name, count});
        }
        catch (SQLException ex) {
            _logger.error("unable to delete resourcesGroup:[id:{}, name:{}]", new Object[]{id, name, ex});
        }
    }

    @Override
    public void delete(Integer id) {
        this.delete(id, null);
    }

    @Override
    public void delete(ResourcesGroup resourcesGroup) {
        this.delete(resourcesGroup.getId(), resourcesGroup.getName());
    }

    @Override
    public void update(ResourcesGroup resourcesGroup) {
        try {
            int count = this.getDao().update((Object)resourcesGroup);
            _logger.debug("Updated ResourcesGroup:[{}], Update count:{}", (Object)resourcesGroup, (Object)count);
        }
        catch (SQLException ex) {
            _logger.error("unable to update resourcesGroup:[{}]", (Object)resourcesGroup, (Object)ex);
        }
    }

    @Override
    public List<ResourcesGroup> getAll() {
        try {
            return this.getDao().queryForAll();
        }
        catch (SQLException ex) {
            _logger.error("unable to get ResourcesGroup", (Throwable)ex);
            return null;
        }
    }

    @Override
    public ResourcesGroup get(ResourcesGroup resourcesGroup) {
        try {
            if (resourcesGroup.getId() != null) {
                return (ResourcesGroup)this.getDao().queryForId((Object)resourcesGroup.getId());
            }
            if (resourcesGroup.getName() != null) {
                QueryBuilder queryBuilder = this.getDao().queryBuilder();
                queryBuilder.where().eq("name", (Object)resourcesGroup.getName());
                return (ResourcesGroup)queryBuilder.queryForFirst();
            }
        }
        catch (SQLException ex) {
            _logger.error("unable to get ResourcesGroup", (Throwable)ex);
            return null;
        }
        return null;
    }

    @Override
    public ResourcesGroup get(Integer id) {
        try {
            return (ResourcesGroup)this.getDao().queryForId((Object)id);
        }
        catch (SQLException ex) {
            _logger.error("unable to get ResourcesGroup", (Throwable)ex);
            return null;
        }
    }

    @Override
    public QueryResponse getAll(Query query) {
        try {
            return this.getQueryResponse(query, "id");
        }
        catch (SQLException ex) {
            _logger.error("unable to run query:[{}]", (Object)query, (Object)ex);
            return null;
        }
    }
}

