/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.db.dao;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.List;
import org.mycontroller.standalone.api.jaxrs.mapper.Query;
import org.mycontroller.standalone.api.jaxrs.mapper.QueryResponse;
import org.mycontroller.standalone.db.dao.BaseAbstractDaoImpl;
import org.mycontroller.standalone.db.dao.NodeDao;
import org.mycontroller.standalone.db.tables.Gateway;
import org.mycontroller.standalone.db.tables.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeDaoImpl
extends BaseAbstractDaoImpl<Node, Integer>
implements NodeDao {
    private static final Logger _logger = LoggerFactory.getLogger(NodeDaoImpl.class);

    public NodeDaoImpl(ConnectionSource connectionSource) throws SQLException {
        super(connectionSource, Node.class);
    }

    @Override
    public void create(Node node) {
        try {
            int count = this.getDao().create((Object)node);
            _logger.debug("Created Node:[{}], Create count:{}", (Object)node, (Object)count);
        }
        catch (SQLException ex) {
            _logger.error("unable to add Node:[{}]", (Object)node, (Object)ex);
        }
    }

    @Override
    public void delete(Node node) {
        try {
            int count = 0;
            if (node.getId() != null) {
                count = this.getDao().delete((Object)node);
            } else {
                DeleteBuilder deleteBuilder = this.getDao().deleteBuilder();
                deleteBuilder.where().eq("gatewayId", (Object)node.getGateway());
                if (node.getEui() != null) {
                    deleteBuilder.where().and().eq("eui", (Object)node.getEui());
                }
                count = deleteBuilder.delete();
            }
            _logger.debug("Node:[{}] deleted, Delete count:{}", (Object)node, (Object)count);
        }
        catch (SQLException ex) {
            _logger.error("unable to delete node:[{}]", (Object)node, (Object)ex);
        }
    }

    @Override
    public void delete(Integer gatewayId, String nodeEui) {
        this.delete(Node.builder().eui(nodeEui).gateway(Gateway.builder().id(gatewayId).build()).build());
    }

    @Override
    public void delete(Integer id) {
        this.delete(Node.builder().id(id).build());
    }

    @Override
    public void update(Node node) {
        try {
            int count = this.getDao().update((Object)node);
            _logger.debug("Updated Node:[{}], Update count:{}", (Object)node, (Object)count);
        }
        catch (SQLException ex) {
            _logger.error("unable to update node:[{}]", (Object)node, (Object)ex);
        }
    }

    @Override
    public List<Node> getAll() {
        try {
            return this.getDao().queryForAll();
        }
        catch (SQLException ex) {
            _logger.error("unable to get all Nodes", (Throwable)ex);
            return null;
        }
    }

    @Override
    public List<Node> getAll(Integer gatewayId) {
        try {
            if (gatewayId != null) {
                return this.getDao().queryForEq("gatewayId", (Object)gatewayId);
            }
            return this.getDao().queryForAll();
        }
        catch (SQLException ex) {
            _logger.error("unable to get all Nodes", (Throwable)ex);
            return null;
        }
    }

    @Override
    public Node get(Node node) {
        if (node.getId() != null) {
            return this.get(node.getId());
        }
        try {
            QueryBuilder queryBuilder = this.getDao().queryBuilder();
            queryBuilder.where().eq("gatewayId", (Object)node.getGateway()).and().eq("eui", (Object)node.getEui());
            return (Node)queryBuilder.queryForFirst();
        }
        catch (SQLException ex) {
            _logger.error("unable to get Node", (Throwable)ex);
            return null;
        }
    }

    @Override
    public Node get(Integer gatewayId, String nodeEui) {
        return this.get(Node.builder().eui(nodeEui).gateway(Gateway.builder().id(gatewayId).build()).build());
    }

    @Override
    public Node get(Integer id) {
        try {
            return (Node)this.getDao().queryForId((Object)id);
        }
        catch (SQLException ex) {
            _logger.error("unable to get Node", (Throwable)ex);
            return null;
        }
    }

    @Override
    public List<Node> getByName(String nodeName) {
        try {
            return this.getDao().queryForEq("name", (Object)nodeName);
        }
        catch (SQLException ex) {
            _logger.error("unable to get node by name", (Throwable)ex);
            return null;
        }
    }

    @Override
    public void createOrUpdate(Node node) {
        try {
            Dao.CreateOrUpdateStatus status = this.getDao().createOrUpdate((Object)node);
            _logger.debug("CreateOrUpdate Node:[{}],Create:{},Update:{},Lines Changed:{}", new Object[]{node, status.isCreated(), status.isUpdated(), status.getNumLinesChanged()});
        }
        catch (SQLException ex) {
            _logger.error("unable to CreateOrUpdate Node:[{}]", (Object)node, (Object)ex);
        }
    }

    @Override
    public long countOf(Integer gatewayId) {
        try {
            QueryBuilder queryBuilder = this.getDao().queryBuilder();
            queryBuilder.where().eq("gatewayId", (Object)gatewayId);
            return queryBuilder.countOf();
        }
        catch (SQLException ex) {
            _logger.error("unable to get Node count:[GatewayId:{}]", (Object)gatewayId, (Object)ex);
            return 0L;
        }
    }

    @Override
    public void delete(List<Integer> nodeIds) {
        try {
            int count = 0;
            if (nodeIds != null) {
                DeleteBuilder deleteBuilder = this.getDao().deleteBuilder();
                deleteBuilder.where().in("id", nodeIds);
                count = deleteBuilder.delete();
            }
            _logger.debug("NodeIds:[{}] deleted, Delete count:{}", nodeIds, (Object)count);
        }
        catch (SQLException ex) {
            _logger.error("unable to delete nodeIds:[{}]", nodeIds, (Object)ex);
        }
    }

    @Override
    public List<Node> get(List<Integer> ids) {
        try {
            if (ids != null) {
                QueryBuilder queryBuilder = this.getDao().queryBuilder();
                queryBuilder.where().in("id", ids);
                return queryBuilder.query();
            }
        }
        catch (SQLException ex) {
            _logger.error("unable to get node for Ids:[{}]", ids, (Object)ex);
        }
        return null;
    }

    @Override
    public QueryResponse getAll(Query query) {
        try {
            return this.getQueryResponse(query, "id");
        }
        catch (SQLException ex) {
            _logger.error("unable to run query:[{}]", (Object)query, (Object)ex);
            return null;
        }
    }
}

