/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.db;

import com.j256.ormlite.jdbc.JdbcPooledConnectionSource;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.ArrayList;
import org.mycontroller.standalone.AppProperties;
import org.mycontroller.standalone.MYCMessages;
import org.mycontroller.standalone.ObjectFactory;
import org.mycontroller.standalone.alarm.jobs.AlarmDefinitionDampeningActiveTimeJob;
import org.mycontroller.standalone.auth.USER_ROLE;
import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.db.DbException;
import org.mycontroller.standalone.db.tables.SystemJob;
import org.mycontroller.standalone.db.tables.User;
import org.mycontroller.standalone.jobs.MidNightJobs;
import org.mycontroller.standalone.jobs.ResourcesLogsAggregationJob;
import org.mycontroller.standalone.metrics.jobs.MetricsAggregationJob;
import org.mycontroller.standalone.settings.EmailSettings;
import org.mycontroller.standalone.settings.LocationSettings;
import org.mycontroller.standalone.settings.MetricsSettings;
import org.mycontroller.standalone.settings.MyControllerSettings;
import org.mycontroller.standalone.settings.MySensorsSettings;
import org.mycontroller.standalone.settings.SettingsUtils;
import org.mycontroller.standalone.settings.SmsSettings;
import org.mycontroller.standalone.settings.Unit;
import org.mycontroller.standalone.settings.UnitsSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataBaseUtils {
    private static final Logger _logger = LoggerFactory.getLogger((String)DataBaseUtils.class.getName());
    private static boolean isDbLoaded = false;
    private static JdbcPooledConnectionSource connectionPooledSource = null;
    private static String databaseUrl = "jdbc:h2:file:" + ObjectFactory.getAppProperties().getDbH2DbLocation();

    private DataBaseUtils() {
    }

    public static ConnectionSource getConnectionSource() throws DbException {
        if (connectionPooledSource != null) {
            _logger.debug("DatabaseConnectionPool Connections,Count[open:{},close:{}],CurrentConnections[free:{},managed:{}],MaxConnectionsEverUsed:{},TestLoopCount:{}", new Object[]{connectionPooledSource.getOpenCount(), connectionPooledSource.getCloseCount(), connectionPooledSource.getCurrentConnectionsFree(), connectionPooledSource.getCurrentConnectionsManaged(), connectionPooledSource.getMaxConnectionsEverUsed(), connectionPooledSource.getTestLoopCount()});
            return connectionPooledSource;
        }
        throw new DbException("Database connection should be inilized before to call me..");
    }

    public static synchronized void loadDatabase() throws SQLException, ClassNotFoundException {
        if (!isDbLoaded) {
            connectionPooledSource = new JdbcPooledConnectionSource(databaseUrl);
            connectionPooledSource.setMaxConnectionAgeMillis(300000L);
            connectionPooledSource.setCheckConnectionsEveryMillis(180000L);
            connectionPooledSource.setTestBeforeGet(true);
            isDbLoaded = true;
            _logger.debug("Database ConnectionSource loaded. Database Url:[{}]", (Object)databaseUrl);
            DaoUtils.loadAllDao();
            ObjectFactory.getAppProperties().loadPropertiesFromDb();
            DataBaseUtils.upgradeSchema();
            ObjectFactory.getAppProperties().loadPropertiesFromDb();
            SettingsUtils.updateStaticJsonInformationFile();
        } else {
            _logger.info("Database ConnectionSource already created. Nothing to do. Database Url:[{}]", (Object)databaseUrl);
        }
    }

    public static void stop() {
        if (connectionPooledSource != null && connectionPooledSource.isOpen()) {
            try {
                connectionPooledSource.close();
                _logger.debug("Database service stopped.");
                isDbLoaded = false;
            }
            catch (SQLException sqlEx) {
                _logger.error("Unable to stop database service, ", (Throwable)sqlEx);
            }
        } else {
            _logger.debug("Database service not running.");
        }
    }

    public static void upgradeSchema() {
        MyControllerSettings controllerSettings = ObjectFactory.getAppProperties().getControllerSettings();
        int dbVersion = 0;
        if (controllerSettings.getDbVersion() != null) {
            dbVersion = controllerSettings.getDbVersion();
        }
        _logger.debug("MC DB Version:{}", (Object)dbVersion);
        if (dbVersion < 6 && dbVersion > 0) {
            throw new RuntimeException("This version of MyController.org database not supported! Workaround: stop MyController.org server, delete existing database, start MyController.org server.");
        }
        if (dbVersion == 0) {
            ArrayList<Unit> unitVariables = new ArrayList<Unit>();
            unitVariables.add(new Unit(MYCMessages.MESSAGE_TYPE_SET_REQ.V_CURRENT.getText(), "A", "A"));
            unitVariables.add(new Unit(MYCMessages.MESSAGE_TYPE_SET_REQ.V_CUSTOM.getText(), "", ""));
            unitVariables.add(new Unit(MYCMessages.MESSAGE_TYPE_SET_REQ.V_DIRECTION.getText(), "\u00b0", "\u00b0"));
            unitVariables.add(new Unit(MYCMessages.MESSAGE_TYPE_SET_REQ.V_DISTANCE.getText(), "cm", "cm"));
            unitVariables.add(new Unit(MYCMessages.MESSAGE_TYPE_SET_REQ.V_FLOW.getText(), "", ""));
            unitVariables.add(new Unit(MYCMessages.MESSAGE_TYPE_SET_REQ.V_GUST.getText(), "mph", "mph"));
            unitVariables.add(new Unit(MYCMessages.MESSAGE_TYPE_SET_REQ.V_HUM.getText(), "%", "%"));
            unitVariables.add(new Unit(MYCMessages.MESSAGE_TYPE_SET_REQ.V_HVAC_SETPOINT_COOL.getText(), "\u00b0C", "\u00b0F"));
            unitVariables.add(new Unit(MYCMessages.MESSAGE_TYPE_SET_REQ.V_HVAC_SETPOINT_HEAT.getText(), "\u00b0C", "\u00b0F"));
            unitVariables.add(new Unit(MYCMessages.MESSAGE_TYPE_SET_REQ.V_IMPEDANCE.getText(), "\u03a9", "\u03a9"));
            unitVariables.add(new Unit(MYCMessages.MESSAGE_TYPE_SET_REQ.V_KWH.getText(), "kWh", "kWh"));
            unitVariables.add(new Unit(MYCMessages.MESSAGE_TYPE_SET_REQ.V_LEVEL.getText(), "%", "%"));
            unitVariables.add(new Unit(MYCMessages.MESSAGE_TYPE_SET_REQ.V_LIGHT_LEVEL.getText(), "%", "%"));
            unitVariables.add(new Unit(MYCMessages.MESSAGE_TYPE_SET_REQ.V_PERCENTAGE.getText(), "%", "%"));
            unitVariables.add(new Unit(MYCMessages.MESSAGE_TYPE_SET_REQ.V_POSITION.getText(), "", ""));
            unitVariables.add(new Unit(MYCMessages.MESSAGE_TYPE_SET_REQ.V_PRESSURE.getText(), "psi", "psi"));
            unitVariables.add(new Unit(MYCMessages.MESSAGE_TYPE_SET_REQ.V_RAIN.getText(), "mm", "mm"));
            unitVariables.add(new Unit(MYCMessages.MESSAGE_TYPE_SET_REQ.V_RAINRATE.getText(), "mm/hr", "mm/hr"));
            unitVariables.add(new Unit(MYCMessages.MESSAGE_TYPE_SET_REQ.V_TEMP.getText(), "\u00b0C", "\u00b0F"));
            unitVariables.add(new Unit(MYCMessages.MESSAGE_TYPE_SET_REQ.V_UV.getText(), "mj/cm2", "mj/cm2"));
            unitVariables.add(new Unit(MYCMessages.MESSAGE_TYPE_SET_REQ.V_VAR1.getText(), "", ""));
            unitVariables.add(new Unit(MYCMessages.MESSAGE_TYPE_SET_REQ.V_VAR2.getText(), "", ""));
            unitVariables.add(new Unit(MYCMessages.MESSAGE_TYPE_SET_REQ.V_VAR3.getText(), "", ""));
            unitVariables.add(new Unit(MYCMessages.MESSAGE_TYPE_SET_REQ.V_VAR4.getText(), "", ""));
            unitVariables.add(new Unit(MYCMessages.MESSAGE_TYPE_SET_REQ.V_VAR5.getText(), "", ""));
            unitVariables.add(new Unit(MYCMessages.MESSAGE_TYPE_SET_REQ.V_VOLTAGE.getText(), "V", "V"));
            unitVariables.add(new Unit(MYCMessages.MESSAGE_TYPE_SET_REQ.V_VOLUME.getText(), "", ""));
            unitVariables.add(new Unit(MYCMessages.MESSAGE_TYPE_SET_REQ.V_WATT.getText(), "W", "W"));
            unitVariables.add(new Unit(MYCMessages.MESSAGE_TYPE_SET_REQ.V_WEIGHT.getText(), "kg", "kg"));
            unitVariables.add(new Unit(MYCMessages.MESSAGE_TYPE_SET_REQ.V_WIND.getText(), "mph", "mph"));
            UnitsSettings.builder().variables(unitVariables).build().save();
            LocationSettings.builder().name("Namakkal").latitude("11.2333").longitude("78.1667").build().save();
            LocationSettings.builder().sunriseTime(0L).sunsetTime(0L).build().updateInternal();
            MySensorsSettings.builder().defaultFirmware(null).enbaledDefaultOnNoFirmware(false).build().save();
            EmailSettings.builder().smtpHost(null).smtpPort(null).enableSsl(false).fromAddress(null).smtpUsername(null).smtpPassword(null).build().save();
            SmsSettings.builder().vendor(null).authSid(null).authToken(null).fromNumber(null).build().save();
            DataBaseUtils.createSystemJob("Metrics aggregate job", "05 * * * * ? *", true, MetricsAggregationJob.class);
            DataBaseUtils.createSystemJob("ResourcesLogs Aggregation Job", "45 * * * * ? *", true, ResourcesLogsAggregationJob.class);
            DataBaseUtils.createSystemJob("Daily once job", "30 3 0 * * ? *", true, MidNightJobs.class);
            DataBaseUtils.createSystemJob("Alarm definition dampening active time", "25,55 * * * * ? *", true, AlarmDefinitionDampeningActiveTimeJob.class);
            User adminUser = new User("admin");
            adminUser.setPassword("admin");
            adminUser.setEmail("admin@localhost.com");
            adminUser.setRoleId(USER_ROLE.ADMIN.ordinal());
            adminUser.setFullName("Admin");
            DaoUtils.getUserDao().create(adminUser);
            MyControllerSettings.builder().language(AppProperties.MC_LANGUAGE.EN_US.getText()).aliveCheckInterval(1800000L).timeFormat(AppProperties.MC_TIME_FORMAT.HOURS_12.getText()).unitConfig(AppProperties.UNIT_CONFIG.METRIC.getText()).loginMessage("Default username: <b>admin</b>, password: <b>admin<b>").build().save();
            MetricsSettings.builder().lastAggregationRawData(System.currentTimeMillis()).lastAggregationOneMinute(System.currentTimeMillis()).lastAggregationFiveMinutes(System.currentTimeMillis()).lastAggregationOneHour(System.currentTimeMillis()).lastAggregationSixHours(System.currentTimeMillis()).lastAggregationTwelveHours(System.currentTimeMillis()).lastAggregationOneDay(System.currentTimeMillis()).build().updateInternal();
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_DOOR, MYCMessages.MESSAGE_TYPE_SET_REQ.V_TRIPPED);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_DOOR, MYCMessages.MESSAGE_TYPE_SET_REQ.V_ARMED);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_MOTION, MYCMessages.MESSAGE_TYPE_SET_REQ.V_TRIPPED);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_MOTION, MYCMessages.MESSAGE_TYPE_SET_REQ.V_ARMED);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_SMOKE, MYCMessages.MESSAGE_TYPE_SET_REQ.V_TRIPPED);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_SMOKE, MYCMessages.MESSAGE_TYPE_SET_REQ.V_ARMED);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_BINARY, MYCMessages.MESSAGE_TYPE_SET_REQ.V_STATUS);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_BINARY, MYCMessages.MESSAGE_TYPE_SET_REQ.V_WATT);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_DIMMER, MYCMessages.MESSAGE_TYPE_SET_REQ.V_STATUS);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_DIMMER, MYCMessages.MESSAGE_TYPE_SET_REQ.V_PERCENTAGE);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_DIMMER, MYCMessages.MESSAGE_TYPE_SET_REQ.V_WATT);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_COVER, MYCMessages.MESSAGE_TYPE_SET_REQ.V_UP);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_COVER, MYCMessages.MESSAGE_TYPE_SET_REQ.V_DOWN);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_COVER, MYCMessages.MESSAGE_TYPE_SET_REQ.V_STOP);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_COVER, MYCMessages.MESSAGE_TYPE_SET_REQ.V_PERCENTAGE);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_TEMP, MYCMessages.MESSAGE_TYPE_SET_REQ.V_TEMP);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_HUM, MYCMessages.MESSAGE_TYPE_SET_REQ.V_HUM);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_BARO, MYCMessages.MESSAGE_TYPE_SET_REQ.V_PRESSURE);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_BARO, MYCMessages.MESSAGE_TYPE_SET_REQ.V_FORECAST);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_WIND, MYCMessages.MESSAGE_TYPE_SET_REQ.V_WIND);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_WIND, MYCMessages.MESSAGE_TYPE_SET_REQ.V_GUST);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_RAIN, MYCMessages.MESSAGE_TYPE_SET_REQ.V_RAIN);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_RAIN, MYCMessages.MESSAGE_TYPE_SET_REQ.V_RAINRATE);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_UV, MYCMessages.MESSAGE_TYPE_SET_REQ.V_UV);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_WEIGHT, MYCMessages.MESSAGE_TYPE_SET_REQ.V_WEIGHT);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_WEIGHT, MYCMessages.MESSAGE_TYPE_SET_REQ.V_IMPEDANCE);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_POWER, MYCMessages.MESSAGE_TYPE_SET_REQ.V_WATT);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_POWER, MYCMessages.MESSAGE_TYPE_SET_REQ.V_KWH);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_HEATER, MYCMessages.MESSAGE_TYPE_SET_REQ.V_HVAC_SETPOINT_HEAT);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_HEATER, MYCMessages.MESSAGE_TYPE_SET_REQ.V_HVAC_FLOW_STATE);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_HEATER, MYCMessages.MESSAGE_TYPE_SET_REQ.V_TEMP);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_DISTANCE, MYCMessages.MESSAGE_TYPE_SET_REQ.V_DISTANCE);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_LIGHT_LEVEL, MYCMessages.MESSAGE_TYPE_SET_REQ.V_LIGHT_LEVEL);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_LIGHT_LEVEL, MYCMessages.MESSAGE_TYPE_SET_REQ.V_LEVEL);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_LOCK, MYCMessages.MESSAGE_TYPE_SET_REQ.V_LOCK_STATUS);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_IR, MYCMessages.MESSAGE_TYPE_SET_REQ.V_IR_SEND);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_IR, MYCMessages.MESSAGE_TYPE_SET_REQ.V_IR_RECEIVE);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_WATER, MYCMessages.MESSAGE_TYPE_SET_REQ.V_FLOW);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_WATER, MYCMessages.MESSAGE_TYPE_SET_REQ.V_VOLUME);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_AIR_QUALITY, MYCMessages.MESSAGE_TYPE_SET_REQ.V_LEVEL);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_CUSTOM, MYCMessages.MESSAGE_TYPE_SET_REQ.V_VAR1);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_CUSTOM, MYCMessages.MESSAGE_TYPE_SET_REQ.V_VAR2);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_CUSTOM, MYCMessages.MESSAGE_TYPE_SET_REQ.V_VAR3);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_CUSTOM, MYCMessages.MESSAGE_TYPE_SET_REQ.V_VAR4);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_CUSTOM, MYCMessages.MESSAGE_TYPE_SET_REQ.V_VAR5);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_DUST, MYCMessages.MESSAGE_TYPE_SET_REQ.V_LEVEL);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_SCENE_CONTROLLER, MYCMessages.MESSAGE_TYPE_SET_REQ.V_SCENE_ON);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_SCENE_CONTROLLER, MYCMessages.MESSAGE_TYPE_SET_REQ.V_SCENE_OFF);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_RGB_LIGHT, MYCMessages.MESSAGE_TYPE_SET_REQ.V_RGB);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_RGB_LIGHT, MYCMessages.MESSAGE_TYPE_SET_REQ.V_WATT);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_RGBW_LIGHT, MYCMessages.MESSAGE_TYPE_SET_REQ.V_RGBW);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_RGBW_LIGHT, MYCMessages.MESSAGE_TYPE_SET_REQ.V_WATT);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_COLOR_SENSOR, MYCMessages.MESSAGE_TYPE_SET_REQ.V_RGB);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_HVAC, MYCMessages.MESSAGE_TYPE_SET_REQ.V_HVAC_SETPOINT_HEAT);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_HVAC, MYCMessages.MESSAGE_TYPE_SET_REQ.V_HVAC_SETPOINT_COOL);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_HVAC, MYCMessages.MESSAGE_TYPE_SET_REQ.V_HVAC_FLOW_STATE);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_HVAC, MYCMessages.MESSAGE_TYPE_SET_REQ.V_HVAC_FLOW_MODE);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_HVAC, MYCMessages.MESSAGE_TYPE_SET_REQ.V_HVAC_SPEED);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_MULTIMETER, MYCMessages.MESSAGE_TYPE_SET_REQ.V_VOLTAGE);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_MULTIMETER, MYCMessages.MESSAGE_TYPE_SET_REQ.V_CURRENT);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_MULTIMETER, MYCMessages.MESSAGE_TYPE_SET_REQ.V_IMPEDANCE);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_SPRINKLER, MYCMessages.MESSAGE_TYPE_SET_REQ.V_STATUS);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_SPRINKLER, MYCMessages.MESSAGE_TYPE_SET_REQ.V_TRIPPED);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_WATER_LEAK, MYCMessages.MESSAGE_TYPE_SET_REQ.V_TRIPPED);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_WATER_LEAK, MYCMessages.MESSAGE_TYPE_SET_REQ.V_ARMED);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_SOUND, MYCMessages.MESSAGE_TYPE_SET_REQ.V_TRIPPED);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_SOUND, MYCMessages.MESSAGE_TYPE_SET_REQ.V_ARMED);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_SOUND, MYCMessages.MESSAGE_TYPE_SET_REQ.V_LEVEL);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_VIBRATION, MYCMessages.MESSAGE_TYPE_SET_REQ.V_TRIPPED);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_VIBRATION, MYCMessages.MESSAGE_TYPE_SET_REQ.V_ARMED);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_VIBRATION, MYCMessages.MESSAGE_TYPE_SET_REQ.V_LEVEL);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_MOISTURE, MYCMessages.MESSAGE_TYPE_SET_REQ.V_TRIPPED);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_MOISTURE, MYCMessages.MESSAGE_TYPE_SET_REQ.V_ARMED);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_MOISTURE, MYCMessages.MESSAGE_TYPE_SET_REQ.V_LEVEL);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_INFO, MYCMessages.MESSAGE_TYPE_SET_REQ.V_TEXT);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_GAS, MYCMessages.MESSAGE_TYPE_SET_REQ.V_FLOW);
            DataBaseUtils.createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION.S_GAS, MYCMessages.MESSAGE_TYPE_SET_REQ.V_VOLUME);
            dbVersion = 8;
            MyControllerSettings.builder().version("0.0.2-alpha7-SNAPSHOT").dbVersion(dbVersion).build().updateInternal();
            _logger.info("MC DB version[{}]", (Object)dbVersion);
        }
    }

    private static void createSensorsVariablesMap(MYCMessages.MESSAGE_TYPE_PRESENTATION sensorType, MYCMessages.MESSAGE_TYPE_SET_REQ variableType) {
        DaoUtils.getSensorsVariablesMapDao().create(sensorType, variableType);
    }

    private static void createSystemJob(String name, String cronExpression, boolean isEnabled, Class<?> clazz) {
        DaoUtils.getSystemJobDao().create(SystemJob.builder().name(name).cron(cronExpression).enabled(isEnabled).className(clazz.getName()).build());
    }

    public static void backupDb() {
    }
}

