/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.api.jaxrs.utils;

import java.util.ArrayList;
import java.util.List;
import org.mycontroller.standalone.AppProperties;
import org.mycontroller.standalone.MYCMessages;
import org.mycontroller.standalone.ObjectFactory;
import org.mycontroller.standalone.alarm.AlarmUtils;
import org.mycontroller.standalone.api.jaxrs.mapper.TypesIdNameMapper;
import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.db.tables.AlarmDefinition;
import org.mycontroller.standalone.db.tables.Firmware;
import org.mycontroller.standalone.db.tables.FirmwareType;
import org.mycontroller.standalone.db.tables.FirmwareVersion;
import org.mycontroller.standalone.db.tables.Gateway;
import org.mycontroller.standalone.db.tables.Node;
import org.mycontroller.standalone.db.tables.ResourcesGroup;
import org.mycontroller.standalone.db.tables.Sensor;
import org.mycontroller.standalone.db.tables.SensorVariable;
import org.mycontroller.standalone.db.tables.SensorsVariablesMap;
import org.mycontroller.standalone.db.tables.Timer;
import org.mycontroller.standalone.gateway.GatewayUtils;
import org.mycontroller.standalone.metrics.MetricsUtils;
import org.mycontroller.standalone.model.ResourceModel;
import org.mycontroller.standalone.timer.TimerUtils;

public class TypesUtils {
    public static final String NODE_IDENTIFIER = "NODE";

    private TypesUtils() {
    }

    public static ArrayList<TypesIdNameMapper> getSensorValueTypes() {
        MYCMessages.MESSAGE_TYPE_SET_REQ[] types = MYCMessages.MESSAGE_TYPE_SET_REQ.values();
        ArrayList<TypesIdNameMapper> typesIdNameMappers = new ArrayList<TypesIdNameMapper>();
        for (MYCMessages.MESSAGE_TYPE_SET_REQ type : types) {
            typesIdNameMappers.add(TypesIdNameMapper.builder().id(type.ordinal()).displayName(type.name()).build());
        }
        return typesIdNameMappers;
    }

    public static ArrayList<TypesIdNameMapper> getSensorTypes() {
        MYCMessages.MESSAGE_TYPE_PRESENTATION[] types = MYCMessages.MESSAGE_TYPE_PRESENTATION.values();
        ArrayList<TypesIdNameMapper> typesIdNameMappers = new ArrayList<TypesIdNameMapper>();
        for (MYCMessages.MESSAGE_TYPE_PRESENTATION type : types) {
            if (type.name().contains(NODE_IDENTIFIER)) continue;
            typesIdNameMappers.add(TypesIdNameMapper.builder().id(type.ordinal()).displayName(type.getText()).build());
        }
        return typesIdNameMappers;
    }

    public static ArrayList<TypesIdNameMapper> getNodeTypes() {
        MYCMessages.MESSAGE_TYPE_PRESENTATION[] types = MYCMessages.MESSAGE_TYPE_PRESENTATION.values();
        ArrayList<TypesIdNameMapper> typesIdNameMappers = new ArrayList<TypesIdNameMapper>();
        for (MYCMessages.MESSAGE_TYPE_PRESENTATION type : types) {
            if (!type.name().contains(NODE_IDENTIFIER)) continue;
            typesIdNameMappers.add(TypesIdNameMapper.builder().id(type.ordinal()).displayName(type.getText()).build());
        }
        return typesIdNameMappers;
    }

    public static ArrayList<TypesIdNameMapper> getAlarmTriggerTypes(String resourceTypeString) {
        AlarmUtils.TRIGGER_TYPE[] triggers = AlarmUtils.TRIGGER_TYPE.values();
        ArrayList<TypesIdNameMapper> typesIdNameMappers = new ArrayList<TypesIdNameMapper>();
        AppProperties.RESOURCE_TYPE resourceType = resourceTypeString != null ? AppProperties.RESOURCE_TYPE.fromString(resourceTypeString) : null;
        block4: for (AlarmUtils.TRIGGER_TYPE triggerType : triggers) {
            if (resourceType != null) {
                switch (resourceType) {
                    case GATEWAY: 
                    case NODE: 
                    case RESOURCES_GROUP: {
                        if (triggerType != AlarmUtils.TRIGGER_TYPE.EQUAL && triggerType != AlarmUtils.TRIGGER_TYPE.NOT_EQUAL) continue block4;
                        typesIdNameMappers.add(TypesIdNameMapper.builder().id(triggerType.ordinal()).displayName(triggerType.getText()).build());
                        break;
                    }
                    case SENSOR_VARIABLE: {
                        typesIdNameMappers.add(TypesIdNameMapper.builder().id(triggerType.ordinal()).displayName(triggerType.getText()).build());
                        break;
                    }
                }
                continue;
            }
            typesIdNameMappers.add(TypesIdNameMapper.builder().id(triggerType.ordinal()).displayName(triggerType.getText()).build());
        }
        return typesIdNameMappers;
    }

    public static ArrayList<TypesIdNameMapper> getAlarmNotificationTypes() {
        AlarmUtils.NOTIFICATION_TYPE[] types = AlarmUtils.NOTIFICATION_TYPE.values();
        ArrayList<TypesIdNameMapper> typesIdNameMappers = new ArrayList<TypesIdNameMapper>();
        for (AlarmUtils.NOTIFICATION_TYPE notificationType : types) {
            typesIdNameMappers.add(TypesIdNameMapper.builder().id(notificationType.ordinal()).displayName(notificationType.getText()).build());
        }
        return typesIdNameMappers;
    }

    public static ArrayList<TypesIdNameMapper> getAlarmThresholdTypes() {
        AlarmUtils.THRESHOLD_TYPE[] types = AlarmUtils.THRESHOLD_TYPE.values();
        ArrayList<TypesIdNameMapper> typesIdNameMappers = new ArrayList<TypesIdNameMapper>();
        for (AlarmUtils.THRESHOLD_TYPE type : types) {
            typesIdNameMappers.add(TypesIdNameMapper.builder().id(type.ordinal()).displayName(type.getText()).build());
        }
        return typesIdNameMappers;
    }

    public static ArrayList<TypesIdNameMapper> getAlarmDampeningTypes() {
        AlarmUtils.DAMPENING_TYPE[] types = AlarmUtils.DAMPENING_TYPE.values();
        ArrayList<TypesIdNameMapper> typesIdNameMappers = new ArrayList<TypesIdNameMapper>();
        for (AlarmUtils.DAMPENING_TYPE type : types) {
            typesIdNameMappers.add(TypesIdNameMapper.builder().id(type.ordinal()).displayName(type.getText()).build());
        }
        return typesIdNameMappers;
    }

    public static ArrayList<TypesIdNameMapper> getStateTypes(String resourceTypeString) {
        AppProperties.STATE[] types = AppProperties.STATE.values();
        AppProperties.RESOURCE_TYPE resourceType = resourceTypeString != null ? AppProperties.RESOURCE_TYPE.fromString(resourceTypeString) : null;
        ArrayList<TypesIdNameMapper> typesIdNameMappers = new ArrayList<TypesIdNameMapper>();
        block4: for (AppProperties.STATE type : types) {
            if (resourceType != null) {
                switch (resourceType) {
                    case GATEWAY: 
                    case NODE: {
                        if (type != AppProperties.STATE.UP && type != AppProperties.STATE.DOWN && type != AppProperties.STATE.UNAVAILABLE) continue block4;
                        typesIdNameMappers.add(TypesIdNameMapper.builder().id(type.ordinal()).displayName(type.getText()).build());
                        break;
                    }
                    case RESOURCES_GROUP: {
                        if (type != AppProperties.STATE.ON && type != AppProperties.STATE.OFF) continue block4;
                        typesIdNameMappers.add(TypesIdNameMapper.builder().id(type.ordinal()).displayName(type.getText()).build());
                        break;
                    }
                }
                continue;
            }
            typesIdNameMappers.add(TypesIdNameMapper.builder().id(type.ordinal()).displayName(type.getText()).build());
        }
        return typesIdNameMappers;
    }

    public static ArrayList<TypesIdNameMapper> getTimerTypes() {
        TimerUtils.TIMER_TYPE[] types = TimerUtils.TIMER_TYPE.values();
        ArrayList<TypesIdNameMapper> typesIdNameMappers = new ArrayList<TypesIdNameMapper>();
        for (TimerUtils.TIMER_TYPE timerType : types) {
            typesIdNameMappers.add(TypesIdNameMapper.builder().id(timerType.ordinal()).displayName(timerType.getText()).build());
        }
        return typesIdNameMappers;
    }

    public static ArrayList<TypesIdNameMapper> getTimerFrequencyTypes() {
        TimerUtils.FREQUENCY_TYPE[] types = TimerUtils.FREQUENCY_TYPE.values();
        ArrayList<TypesIdNameMapper> typesIdNameMappers = new ArrayList<TypesIdNameMapper>();
        for (TimerUtils.FREQUENCY_TYPE type : types) {
            typesIdNameMappers.add(TypesIdNameMapper.builder().id(type.ordinal()).displayName(type.getText()).build());
        }
        return typesIdNameMappers;
    }

    public static ArrayList<TypesIdNameMapper> getTimerWeekDays(boolean isAllDaysTicked) {
        TimerUtils.WEEK_DAY[] types = TimerUtils.WEEK_DAY.values();
        ArrayList<TypesIdNameMapper> typesIdNameMappers = new ArrayList<TypesIdNameMapper>();
        for (TimerUtils.WEEK_DAY type : types) {
            typesIdNameMappers.add(TypesIdNameMapper.builder().id(type.ordinal()).displayName(type.getText()).ticked(isAllDaysTicked).build());
        }
        return typesIdNameMappers;
    }

    public static ArrayList<TypesIdNameMapper> getResourceTypes(String resourceType) {
        AppProperties.RESOURCE_TYPE[] types = AppProperties.RESOURCE_TYPE.values();
        ArrayList<TypesIdNameMapper> typesIdNameMappers = new ArrayList<TypesIdNameMapper>();
        AppProperties.RESOURCE_TYPE resourceTypeFilter = null;
        if (resourceType != null) {
            resourceTypeFilter = AppProperties.RESOURCE_TYPE.fromString(resourceType);
        }
        block4: for (AppProperties.RESOURCE_TYPE type : types) {
            if (resourceTypeFilter != null) {
                switch (resourceTypeFilter) {
                    case ALARM_DEFINITION: 
                    case TIMER: {
                        if (type == AppProperties.RESOURCE_TYPE.ALARM_DEFINITION || type == AppProperties.RESOURCE_TYPE.TIMER || type == AppProperties.RESOURCE_TYPE.SENSOR) continue block4;
                        typesIdNameMappers.add(TypesIdNameMapper.builder().id(type.ordinal()).displayName(type.getText()).build());
                        break;
                    }
                    case RESOURCES_GROUP: {
                        if (type == AppProperties.RESOURCE_TYPE.ALARM_DEFINITION || type == AppProperties.RESOURCE_TYPE.TIMER || type == AppProperties.RESOURCE_TYPE.SENSOR || type == AppProperties.RESOURCE_TYPE.RESOURCES_GROUP) continue block4;
                        typesIdNameMappers.add(TypesIdNameMapper.builder().id(type.ordinal()).displayName(type.getText()).build());
                        break;
                    }
                    default: {
                        typesIdNameMappers.add(TypesIdNameMapper.builder().id(type.ordinal()).displayName(type.getText()).build());
                        break;
                    }
                }
                continue;
            }
            typesIdNameMappers.add(TypesIdNameMapper.builder().id(type.ordinal()).displayName(type.getText()).build());
        }
        return typesIdNameMappers;
    }

    public static ArrayList<TypesIdNameMapper> getResources(String resourceType) {
        if (resourceType == null) {
            return null;
        }
        AppProperties.RESOURCE_TYPE resourceTypeEnum = AppProperties.RESOURCE_TYPE.fromString(resourceType);
        ArrayList<TypesIdNameMapper> typesIdNameMappers = new ArrayList<TypesIdNameMapper>();
        StringBuilder builder = new StringBuilder();
        switch (resourceTypeEnum) {
            case GATEWAY: {
                List gateways = DaoUtils.getGatewayDao().getAll();
                for (Gateway type : gateways) {
                    typesIdNameMappers.add(TypesIdNameMapper.builder().id(type.getId()).displayName(type.getName()).build());
                }
                break;
            }
            case NODE: {
                List<Node> nodes = DaoUtils.getNodeDao().getAll();
                for (Node type : nodes) {
                    builder.setLength(0);
                    builder.append(type.getGateway().getName()).append(" -> ").append("[").append(type.getEui()).append("]").append(type.getName());
                    typesIdNameMappers.add(TypesIdNameMapper.builder().id(type.getId()).displayName(builder.toString()).build());
                }
                break;
            }
            case SENSOR: {
                List sensors = DaoUtils.getSensorDao().getAll();
                for (Sensor type : sensors) {
                    builder.setLength(0);
                    builder.append(type.getNode().getGateway().getName()).append(" -> ").append("[").append(type.getNode().getEui()).append("]").append(type.getNode().getName()).append(" -> [").append(type.getSensorId()).append("]").append(type.getName());
                    typesIdNameMappers.add(TypesIdNameMapper.builder().id(type.getId()).displayName(builder.toString()).build());
                }
                break;
            }
            case SENSOR_VARIABLE: {
                List<SensorVariable> sensorVariables = DaoUtils.getSensorVariableDao().getAll();
                for (SensorVariable type : sensorVariables) {
                    builder.setLength(0);
                    builder.append(type.getSensor().getNode().getGateway().getName()).append(" -> [").append(type.getSensor().getNode().getEui()).append("]").append(type.getSensor().getNode().getName()).append(" -> [").append(type.getSensor().getSensorId()).append("]").append(type.getSensor().getName()).append(" -> ").append(type.getVariableType().getText());
                    typesIdNameMappers.add(TypesIdNameMapper.builder().id(type.getId()).displayName(builder.toString()).build());
                }
                break;
            }
            default: {
                return null;
            }
        }
        return typesIdNameMappers;
    }

    public static ArrayList<TypesIdNameMapper> getGateways() {
        List gateways = DaoUtils.getGatewayDao().getAll();
        ArrayList<TypesIdNameMapper> typesIdNameMappers = new ArrayList<TypesIdNameMapper>();
        for (Gateway gateway : gateways) {
            typesIdNameMappers.add(TypesIdNameMapper.builder().id(gateway.getId()).displayName(new ResourceModel(AppProperties.RESOURCE_TYPE.GATEWAY, gateway).getResourceLessDetails()).build());
        }
        return typesIdNameMappers;
    }

    public static ArrayList<TypesIdNameMapper> getNodes(Integer gatewayId) {
        List<Node> nodes = null;
        nodes = gatewayId != null ? DaoUtils.getNodeDao().getAll(gatewayId) : DaoUtils.getNodeDao().getAll();
        ArrayList<TypesIdNameMapper> typesIdNameMappers = new ArrayList<TypesIdNameMapper>();
        for (Node node : nodes) {
            typesIdNameMappers.add(TypesIdNameMapper.builder().id(node.getId()).displayName(new ResourceModel(AppProperties.RESOURCE_TYPE.NODE, node).getResourceLessDetails()).build());
        }
        return typesIdNameMappers;
    }

    public static ArrayList<TypesIdNameMapper> getResourcesGroups() {
        List<ResourcesGroup> resourcesGroups = DaoUtils.getResourcesGroupDao().getAll();
        ArrayList<TypesIdNameMapper> typesIdNameMappers = new ArrayList<TypesIdNameMapper>();
        for (ResourcesGroup resourcesGroup : resourcesGroups) {
            typesIdNameMappers.add(TypesIdNameMapper.builder().id(resourcesGroup.getId()).displayName(new ResourceModel(AppProperties.RESOURCE_TYPE.RESOURCES_GROUP, resourcesGroup).getResourceLessDetails()).build());
        }
        return typesIdNameMappers;
    }

    public static ArrayList<TypesIdNameMapper> getTimers() {
        ArrayList<TypesIdNameMapper> typesIdNameMappers = new ArrayList<TypesIdNameMapper>();
        List<Timer> timers = DaoUtils.getTimerDao().getAll();
        for (Timer timer : timers) {
            typesIdNameMappers.add(TypesIdNameMapper.builder().id(timer.getId()).displayName(new ResourceModel(AppProperties.RESOURCE_TYPE.TIMER, timer).getResourceLessDetails()).build());
        }
        return typesIdNameMappers;
    }

    public static ArrayList<TypesIdNameMapper> getFirmwareTypes() {
        ArrayList<TypesIdNameMapper> typesIdNameMappers = new ArrayList<TypesIdNameMapper>();
        List firmwareTypes = DaoUtils.getFirmwareTypeDao().getAll();
        for (FirmwareType firmwareType : firmwareTypes) {
            typesIdNameMappers.add(TypesIdNameMapper.builder().id(firmwareType.getId()).displayName(firmwareType.getName()).build());
        }
        return typesIdNameMappers;
    }

    public static ArrayList<TypesIdNameMapper> getFirmwareVersions() {
        ArrayList<TypesIdNameMapper> typesIdNameMappers = new ArrayList<TypesIdNameMapper>();
        List firmwareVersions = DaoUtils.getFirmwareVersionDao().getAll();
        for (FirmwareVersion firmwareVersion : firmwareVersions) {
            typesIdNameMappers.add(TypesIdNameMapper.builder().id(firmwareVersion.getId()).displayName(firmwareVersion.getVersion()).build());
        }
        return typesIdNameMappers;
    }

    public static ArrayList<TypesIdNameMapper> getFirmwares() {
        ArrayList<TypesIdNameMapper> typesIdNameMappers = new ArrayList<TypesIdNameMapper>();
        List firmwares = DaoUtils.getFirmwareDao().getAll();
        for (Firmware firmware : firmwares) {
            typesIdNameMappers.add(TypesIdNameMapper.builder().id(firmware.getId()).displayName(firmware.getType().getName() + ":" + firmware.getVersion().getVersion()).build());
        }
        return typesIdNameMappers;
    }

    public static ArrayList<TypesIdNameMapper> getAlarmDefinitions() {
        ArrayList<TypesIdNameMapper> typesIdNameMappers = new ArrayList<TypesIdNameMapper>();
        List alarmDefinitions = DaoUtils.getAlarmDefinitionDao().getAll();
        for (AlarmDefinition alarmDefinition : alarmDefinitions) {
            typesIdNameMappers.add(TypesIdNameMapper.builder().id(alarmDefinition.getId()).displayName(new ResourceModel(AppProperties.RESOURCE_TYPE.ALARM_DEFINITION, alarmDefinition).getResourceLessDetails()).build());
        }
        return typesIdNameMappers;
    }

    public static ArrayList<TypesIdNameMapper> getSensors(Integer nodeId) {
        List<Object> nodes = new ArrayList<Node>();
        ArrayList<TypesIdNameMapper> typesIdNameMappers = new ArrayList<TypesIdNameMapper>();
        if (nodeId != null) {
            nodes.add(Node.builder().id(nodeId).build());
        } else {
            nodes = DaoUtils.getNodeDao().getAll();
        }
        for (Node node : nodes) {
            List<Sensor> sensors = DaoUtils.getSensorDao().getAll(node.getId());
            for (Sensor sensor : sensors) {
                typesIdNameMappers.add(TypesIdNameMapper.builder().id(sensor.getId()).subId(sensor.getSensorId()).displayName(new ResourceModel(AppProperties.RESOURCE_TYPE.SENSOR, sensor).getResourceLessDetails()).build());
            }
        }
        return typesIdNameMappers;
    }

    public static ArrayList<TypesIdNameMapper> getSensorVariables(Integer sensorId) {
        ArrayList<TypesIdNameMapper> typesIdNameMappers = new ArrayList<TypesIdNameMapper>();
        List<Object> sensors = new ArrayList();
        if (sensorId != null) {
            Sensor sensor = new Sensor();
            sensor.setId(sensorId);
            sensors.add(sensor);
        } else {
            sensors = DaoUtils.getSensorDao().getAll();
        }
        for (Sensor sensor : sensors) {
            List<SensorVariable> sensorVariables = DaoUtils.getSensorVariableDao().getAll(sensor.getId());
            for (SensorVariable sensorVariable : sensorVariables) {
                typesIdNameMappers.add(TypesIdNameMapper.builder().id(sensorVariable.getId()).displayName(new ResourceModel(AppProperties.RESOURCE_TYPE.SENSOR_VARIABLE, sensorVariable).getResourceLessDetails()).build());
            }
        }
        return typesIdNameMappers;
    }

    public static ArrayList<String> getGraphInterpolateTypes() {
        ArrayList<String> types = new ArrayList<String>();
        types.add("linear");
        types.add("basis");
        types.add("cardinal");
        types.add("monotone");
        types.add("bundle");
        types.add("step-before");
        types.add("step-after");
        types.add("basis-open");
        types.add("basis-closed");
        types.add("cardinal-open");
        types.add("cardinal-closed");
        return types;
    }

    public static ArrayList<String> getConfigUnitTypes() {
        AppProperties.UNIT_CONFIG[] configTypes;
        ArrayList<String> types = new ArrayList<String>();
        for (AppProperties.UNIT_CONFIG configType : configTypes = AppProperties.UNIT_CONFIG.values()) {
            types.add(configType.getText());
        }
        return types;
    }

    public static ArrayList<TypesIdNameMapper> getSensorVariableTypes(MYCMessages.MESSAGE_TYPE_PRESENTATION sensorType, Integer sensorId) {
        if (sensorType == null) {
            return null;
        }
        List<SensorsVariablesMap> variableTypes = DaoUtils.getSensorsVariablesMapDao().getAll(sensorType);
        ArrayList<TypesIdNameMapper> typesIdNameMappers = new ArrayList<TypesIdNameMapper>();
        for (SensorsVariablesMap variableType : variableTypes) {
            typesIdNameMappers.add(TypesIdNameMapper.builder().id(variableType.getVariableType().getText()).displayName(variableType.getVariableType().getText()).ticked(false).build());
        }
        if (sensorId != null) {
            List<SensorVariable> sensorVariables = DaoUtils.getSensorVariableDao().getAll(sensorId);
            for (SensorVariable sensorVariable : sensorVariables) {
                for (TypesIdNameMapper idNameMapper : typesIdNameMappers) {
                    if (!idNameMapper.getDisplayName().equals(sensorVariable.getVariableType().getText())) continue;
                    idNameMapper.setSubId(sensorVariable.getId());
                    idNameMapper.setTicked(true);
                }
            }
        }
        return typesIdNameMappers;
    }

    public static ArrayList<TypesIdNameMapper> getGraphSensorVariableTypes(int sensorRefId) {
        ArrayList<TypesIdNameMapper> typesIdNameMappers = new ArrayList<TypesIdNameMapper>();
        List<SensorVariable> sensorVariables = DaoUtils.getSensorVariableDao().getAll(sensorRefId);
        for (SensorVariable sensorVariable : sensorVariables) {
            if (sensorVariable.getMetricType() == MetricsUtils.METRIC_TYPE.NONE) continue;
            typesIdNameMappers.add(TypesIdNameMapper.builder().id(sensorVariable.getId()).subId(sensorVariable.getSensor().getId()).displayName(sensorVariable.getVariableType().getText()).build());
        }
        return typesIdNameMappers;
    }

    public static ArrayList<TypesIdNameMapper> getSensorVariableMapperByType(MYCMessages.MESSAGE_TYPE_PRESENTATION sensorType) {
        MYCMessages.MESSAGE_TYPE_SET_REQ[] types;
        ArrayList<TypesIdNameMapper> typesIdNameMappers = new ArrayList<TypesIdNameMapper>();
        List<SensorsVariablesMap> variablesMap = DaoUtils.getSensorsVariablesMapDao().getAll(sensorType);
        ArrayList<String> variables = new ArrayList<String>();
        for (SensorsVariablesMap variableMap : variablesMap) {
            variables.add(variableMap.getVariableType().getText());
        }
        for (MYCMessages.MESSAGE_TYPE_SET_REQ type : types = MYCMessages.MESSAGE_TYPE_SET_REQ.values()) {
            typesIdNameMappers.add(TypesIdNameMapper.builder().id(type.getText()).displayName(type.getText()).ticked(variables != null ? variables.contains(type.getText()) : false).build());
        }
        return typesIdNameMappers;
    }

    public static ArrayList<TypesIdNameMapper> getMessageTypes() {
        MYCMessages.MESSAGE_TYPE[] types = MYCMessages.MESSAGE_TYPE.values();
        ArrayList<TypesIdNameMapper> typesIdNameMappers = new ArrayList<TypesIdNameMapper>();
        for (MYCMessages.MESSAGE_TYPE type : types) {
            typesIdNameMappers.add(TypesIdNameMapper.builder().id(type.ordinal()).displayName(type.toString()).build());
        }
        return typesIdNameMappers;
    }

    public static ArrayList<TypesIdNameMapper> getMessageSubTypes(int messageType) {
        ArrayList<TypesIdNameMapper> typesIdNameMappers = new ArrayList<TypesIdNameMapper>();
        switch (MYCMessages.MESSAGE_TYPE.get(messageType)) {
            case C_INTERNAL: {
                MYCMessages.MESSAGE_TYPE_INTERNAL[] typesInt;
                for (MYCMessages.MESSAGE_TYPE_INTERNAL type : typesInt = MYCMessages.MESSAGE_TYPE_INTERNAL.values()) {
                    typesIdNameMappers.add(TypesIdNameMapper.builder().id(type.ordinal()).displayName(type.toString()).build());
                }
                break;
            }
            case C_PRESENTATION: {
                MYCMessages.MESSAGE_TYPE_PRESENTATION[] typesPre;
                for (MYCMessages.MESSAGE_TYPE_PRESENTATION type : typesPre = MYCMessages.MESSAGE_TYPE_PRESENTATION.values()) {
                    typesIdNameMappers.add(TypesIdNameMapper.builder().id(type.ordinal()).displayName(type.toString()).build());
                }
                break;
            }
            case C_REQ: 
            case C_SET: {
                MYCMessages.MESSAGE_TYPE_SET_REQ[] typesSetReq;
                for (MYCMessages.MESSAGE_TYPE_SET_REQ type : typesSetReq = MYCMessages.MESSAGE_TYPE_SET_REQ.values()) {
                    typesIdNameMappers.add(TypesIdNameMapper.builder().id(type.ordinal()).displayName(type.toString()).build());
                }
                break;
            }
            case C_STREAM: {
                MYCMessages.MESSAGE_TYPE_STREAM[] typesStr;
                for (MYCMessages.MESSAGE_TYPE_STREAM type : typesStr = MYCMessages.MESSAGE_TYPE_STREAM.values()) {
                    typesIdNameMappers.add(TypesIdNameMapper.builder().id(type.ordinal()).displayName(type.toString()).build());
                }
                break;
            }
        }
        return typesIdNameMappers;
    }

    public static List<TypesIdNameMapper> getVariableMapperList() {
        MYCMessages.MESSAGE_TYPE_PRESENTATION[] types;
        ArrayList<TypesIdNameMapper> typesIdNameMappers = new ArrayList<TypesIdNameMapper>();
        ArrayList<String> variables = new ArrayList<String>();
        for (MYCMessages.MESSAGE_TYPE_PRESENTATION type : types = MYCMessages.MESSAGE_TYPE_PRESENTATION.values()) {
            if (type.name().contains(NODE_IDENTIFIER)) continue;
            variables.clear();
            List<SensorsVariablesMap> variablesMap = DaoUtils.getSensorsVariablesMapDao().getAll(type);
            if (variablesMap != null) {
                for (SensorsVariablesMap sensorsVariablesMap : variablesMap) {
                    variables.add(sensorsVariablesMap.getVariableType().getText());
                }
            }
            typesIdNameMappers.add(TypesIdNameMapper.builder().id(type.getText()).displayName(type.getText()).value(variables.clone()).build());
        }
        return typesIdNameMappers;
    }

    public static void updateVariableMap(TypesIdNameMapper idNameMapper) {
        MYCMessages.MESSAGE_TYPE_PRESENTATION sensorType = MYCMessages.MESSAGE_TYPE_PRESENTATION.fromString(String.valueOf(idNameMapper.getDisplayName()));
        DaoUtils.getSensorsVariablesMapDao().delete(sensorType);
        List variables = (List)idNameMapper.getValue();
        if (variables != null && variables.size() > 0) {
            for (String variable : variables) {
                DaoUtils.getSensorsVariablesMapDao().create(sensorType, MYCMessages.MESSAGE_TYPE_SET_REQ.fromString(variable));
            }
        }
    }

    public static ArrayList<TypesIdNameMapper> getLanguages() {
        AppProperties.MC_LANGUAGE[] languages = AppProperties.MC_LANGUAGE.values();
        ArrayList<TypesIdNameMapper> typesIdNameMappers = new ArrayList<TypesIdNameMapper>();
        AppProperties.MC_LANGUAGE selected = ObjectFactory.getAppProperties().getLanguage();
        for (AppProperties.MC_LANGUAGE language : languages) {
            if (selected == language) {
                typesIdNameMappers.add(TypesIdNameMapper.builder().id(language.name().toLowerCase()).displayName(language.getText()).ticked(true).build());
                continue;
            }
            typesIdNameMappers.add(TypesIdNameMapper.builder().id(language.name().toLowerCase()).displayName(language.getText()).build());
        }
        return typesIdNameMappers;
    }

    public static ArrayList<TypesIdNameMapper> getTimeFormats() {
        AppProperties.MC_TIME_FORMAT[] formats;
        ArrayList<TypesIdNameMapper> typesIdNameMappers = new ArrayList<TypesIdNameMapper>();
        for (AppProperties.MC_TIME_FORMAT format : formats = AppProperties.MC_TIME_FORMAT.values()) {
            typesIdNameMappers.add(TypesIdNameMapper.builder().id(format.name()).displayName(format.getText()).build());
        }
        return typesIdNameMappers;
    }

    public static ArrayList<TypesIdNameMapper> getGatewayTypes() {
        GatewayUtils.TYPE[] types = GatewayUtils.TYPE.values();
        ArrayList<TypesIdNameMapper> typesIdNameMappers = new ArrayList<TypesIdNameMapper>();
        for (GatewayUtils.TYPE type : types) {
            typesIdNameMappers.add(TypesIdNameMapper.builder().id(type.getText()).displayName(type.getText()).build());
        }
        return typesIdNameMappers;
    }

    public static ArrayList<TypesIdNameMapper> getGatewayNetworkTypes() {
        AppProperties.NETWORK_TYPE[] types = AppProperties.NETWORK_TYPE.values();
        ArrayList<TypesIdNameMapper> typesIdNameMappers = new ArrayList<TypesIdNameMapper>();
        for (AppProperties.NETWORK_TYPE type : types) {
            typesIdNameMappers.add(TypesIdNameMapper.builder().id(type.getText()).displayName(type.getText()).build());
        }
        return typesIdNameMappers;
    }

    public static ArrayList<TypesIdNameMapper> getGatewaySerialDrivers() {
        GatewayUtils.SERIAL_PORT_DRIVER[] types = GatewayUtils.SERIAL_PORT_DRIVER.values();
        ArrayList<TypesIdNameMapper> typesIdNameMappers = new ArrayList<TypesIdNameMapper>();
        for (GatewayUtils.SERIAL_PORT_DRIVER type : types) {
            typesIdNameMappers.add(TypesIdNameMapper.builder().id(type.getText()).displayName(type.getText()).build());
        }
        return typesIdNameMappers;
    }
}

