/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.standalone.api.jaxrs;

import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.mycontroller.standalone.api.jaxrs.utils.RestUtils;
import org.mycontroller.standalone.db.DaoUtils;
import org.mycontroller.standalone.db.tables.UidTag;

@Path(value="/rest/uidtag")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@RolesAllowed(value={"admin"})
public class UidTagHandler {
    @GET
    @Path(value="/")
    public Response getAll() {
        return RestUtils.getResponse(Response.Status.OK, DaoUtils.getUidTagDao().getAll());
    }

    @DELETE
    @Path(value="/{uid}")
    public Response delete(@PathParam(value="uid") int uid) {
        DaoUtils.getUidTagDao().delete(uid);
        return RestUtils.getResponse(Response.Status.OK);
    }

    @POST
    @Path(value="/")
    public Response add(UidTag uidTag) {
        DaoUtils.getUidTagDao().create(uidTag);
        return RestUtils.getResponse(Response.Status.CREATED);
    }
}

